/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.plugins.authentication.impl.config.SsoType;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class SsoConfig {
    private final boolean redirectOnLogin;
    private final boolean allowRedirectOverride;
    private final boolean includeCustomerLogins;
    private final boolean enableRememberMe;

    protected SsoConfig(boolean redirectOnLogin, boolean allowRedirectOverride, boolean includeCustomerLogins, boolean enableRememberMe) {
        this.redirectOnLogin = redirectOnLogin;
        this.allowRedirectOverride = allowRedirectOverride;
        this.includeCustomerLogins = includeCustomerLogins;
        this.enableRememberMe = enableRememberMe;
    }

    @Nonnull
    public abstract SsoType getSsoType();

    public boolean isRedirectOnLogin() {
        return this.redirectOnLogin;
    }

    public boolean isAllowRedirectOverride() {
        return this.allowRedirectOverride;
    }

    public boolean isIncludeCustomerLogins() {
        return this.includeCustomerLogins;
    }

    public boolean isEnableRememberMe() {
        return this.enableRememberMe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SsoConfig)) {
            return false;
        }
        SsoConfig ssoConfig = (SsoConfig)o;
        return this.redirectOnLogin == ssoConfig.redirectOnLogin && this.allowRedirectOverride == ssoConfig.allowRedirectOverride && this.includeCustomerLogins == ssoConfig.includeCustomerLogins && this.enableRememberMe == ssoConfig.enableRememberMe;
    }

    public abstract Builder toBuilder();

    public int hashCode() {
        return Objects.hash(this.redirectOnLogin, this.allowRedirectOverride, this.includeCustomerLogins, this.enableRememberMe);
    }

    public static abstract class Builder<T extends Builder> {
        protected boolean redirectOnLogin;
        protected boolean allowRedirectOverride;
        protected boolean includeCustomerLogins;
        protected boolean enableRememberMe = true;

        protected Builder() {
        }

        protected Builder(@Nonnull SsoConfig ssoConfig) {
            this.redirectOnLogin = ssoConfig.isRedirectOnLogin();
            this.allowRedirectOverride = ssoConfig.isAllowRedirectOverride();
            this.includeCustomerLogins = ssoConfig.isIncludeCustomerLogins();
            this.enableRememberMe = ssoConfig.isEnableRememberMe();
        }

        public T setRedirectOnLogin(boolean redirectOnLogin) {
            this.redirectOnLogin = redirectOnLogin;
            return (T)this;
        }

        public T setIncludeCustomerLogins(boolean includeCustomerLogins) {
            this.includeCustomerLogins = includeCustomerLogins;
            return (T)this;
        }

        public T setAllowRedirectOverride(boolean allowRedirectOverride) {
            this.allowRedirectOverride = allowRedirectOverride;
            return (T)this;
        }

        public T setEnableRememberMe(boolean enableRememberMe) {
            this.enableRememberMe = enableRememberMe;
            return (T)this;
        }

        @Nonnull
        public abstract SsoConfig build();
    }
}

