/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.saml;

import com.atlassian.plugins.authentication.impl.util.SimpleStriped;
import com.atlassian.plugins.authentication.impl.web.CookieService;
import com.atlassian.plugins.authentication.impl.web.saml.SessionData;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SessionDataService {
    private static final Logger log = LoggerFactory.getLogger(SessionDataService.class);
    static final String AUTH_SESSION_DATA = "com.atlassian.plugins.authentication.sessiondata";
    static final String REQUEST_ID_GRACE_PERIOD_SECONDS_PROPERTY_NAME = "com.atlassian.plugins.authentication.impl.web.saml.SessionDataService.requestIdGracePeriodSeconds";
    private static final int DEFAULT_REQUEST_ID_GRACE_PERIOD_SECONDS = 60;
    public static final int STRIPE_COUNT = Integer.parseInt(System.getProperty("com.atlassian.plugins.authentication.impl.web.saml.SessionDataService.stripeCount", "64"));
    static final String USER_LOGGED_IN_WITH_SAML = "com.atlassian.plugins.authentication.userLoggedInWithSaml";
    private static final String LOGGED_OUT_FROM_SERVICE_DESK = "was-logged-out";
    private final SimpleStriped sessionLocks;
    private final CookieService cookieService;
    private final Cache<String, SessionData> globalSessionDataCache;

    @Inject
    public SessionDataService(CookieService cookieService) {
        this(cookieService, Integer.getInteger(REQUEST_ID_GRACE_PERIOD_SECONDS_PROPERTY_NAME, 60));
    }

    public SessionDataService(CookieService cookieService, int requestIdGracePeriod) {
        this.cookieService = cookieService;
        this.sessionLocks = new SimpleStriped(STRIPE_COUNT);
        this.globalSessionDataCache = CacheBuilder.newBuilder().expireAfterWrite((long)requestIdGracePeriod, TimeUnit.SECONDS).build();
    }

    public void setSessionData(HttpServletRequest request, String key, SessionData sessionData) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)sessionData);
        HttpSession session = request.getSession(true);
        Map<String, SessionData> sessionDataMap = this.getSessionDataMap(session, true).orElseThrow(() -> new IllegalStateException("Failed to store session data"));
        sessionDataMap.put(key, sessionData);
        log.debug("Saved login session data {} in user session: {} using key {}", new Object[]{sessionData, request.getSession().getId(), key});
    }

    public Optional<SessionData> getSessionData(HttpServletRequest request, HttpServletResponse response, String key) {
        if (key == null) {
            return Optional.empty();
        }
        SessionData sessionData = Optional.ofNullable(request.getSession(false)).flatMap(this::getSessionDataMapSafe).map(sessionMap -> (SessionData)sessionMap.remove(key)).orElse((SessionData)this.globalSessionDataCache.getIfPresent((Object)key));
        this.globalSessionDataCache.invalidate((Object)key);
        if (sessionData != null) {
            Optional<String> urlFragment = this.extractAndInvalidateFragmentCookieValue(request, response);
            sessionData = new SessionData(sessionData.getSamlRequest(), this.prepareTargetUrlWithFragment(sessionData.getTargetUrl(), urlFragment));
        }
        return Optional.ofNullable(sessionData);
    }

    private Optional<String> extractAndInvalidateFragmentCookieValue(HttpServletRequest request, HttpServletResponse response) {
        String cookieName = "atlassian-authentication-plugin-url-fragment_" + request.getParameter("RelayState");
        Optional<Cookie> fragmentCookie = this.cookieService.getCookieFromRequest(cookieName, request);
        fragmentCookie.ifPresent(cookie -> this.cookieService.removeCookie(cookieName, response));
        return fragmentCookie.map(Cookie::getValue);
    }

    private Optional<Map<String, SessionData>> getSessionDataMapSafe(HttpSession session) {
        try {
            return this.getSessionDataMap(session, false);
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    private Optional<Map<String, SessionData>> getSessionDataMap(HttpSession session, boolean createIfEmpty) {
        return Optional.ofNullable(this.sessionLocks.withLock(Strings.nullToEmpty((String)session.getId()), () -> {
            ConcurrentHashMap sessionDataMap = (ConcurrentHashMap)session.getAttribute(AUTH_SESSION_DATA);
            if (createIfEmpty && sessionDataMap == null) {
                sessionDataMap = new ConcurrentHashMap();
                session.setAttribute(AUTH_SESSION_DATA, sessionDataMap);
            }
            return sessionDataMap;
        }));
    }

    private URI prepareTargetUrlWithFragment(Optional<URI> targetUri, Optional<String> fragment) {
        try {
            return UriBuilder.fromUri((URI)targetUri.orElse(new URI(""))).fragment((String)fragment.orElse(null)).build(new Object[0]);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void ensureSessionExists(HttpServletRequest request) {
        request.getSession(true);
    }

    public void requireNewSession(HttpServletRequest request) {
        HttpSession oldSession = request.getSession(false);
        if (oldSession != null) {
            try {
                this.getSessionDataMapSafe(oldSession).ifPresent(arg_0 -> this.globalSessionDataCache.putAll(arg_0));
                oldSession.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.ensureSessionExists(request);
    }

    public void setUserLoggedInWithSaml(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        session.setAttribute(USER_LOGGED_IN_WITH_SAML, (Object)Boolean.TRUE);
    }

    public boolean isUserLoggedInWithSaml(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        Object sessionAttribute = session.getAttribute(USER_LOGGED_IN_WITH_SAML);
        return sessionAttribute != null && (Boolean)sessionAttribute != false;
    }

    public boolean wasLoggedOutFromSdCustomerPortal(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getSession(true).getAttribute(LOGGED_OUT_FROM_SERVICE_DESK));
    }

    public void setLoggedOutFromSdCustomerPortal(HttpServletRequest request, boolean value) {
        HttpSession session = request.getSession(true);
        if (value) {
            session.setAttribute(LOGGED_OUT_FROM_SERVICE_DESK, (Object)value);
        } else {
            session.removeAttribute(LOGGED_OUT_FROM_SERVICE_DESK);
        }
    }
}

