/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.ui.admin;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.atlassian.plugins.authentication.impl.util.ProductLicenseDataProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationConfigurationServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationConfigurationServlet.class);
    static final String URL = "/plugins/servlet/authentication-config";
    static final String TEMPLATE_NAME = "AuthenticationPlugin.Configuration.display";
    private final SoyTemplateRenderer renderer;
    private final SamlConfigService samlConfigService;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final ApplicationProperties applicationProperties;
    private final WebSudoManager webSudoManager;
    private final ProductLicenseDataProvider productLicenseDataProvider;
    private HttpsValidator httpsValidator;

    @Inject
    public AuthenticationConfigurationServlet(@ComponentImport SoyTemplateRenderer renderer, SamlConfigService samlConfigService, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport WebSudoManager webSudoManager, ProductLicenseDataProvider productLicenseDataProvider, HttpsValidator httpsValidator) {
        this.renderer = renderer;
        this.samlConfigService = samlConfigService;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.applicationProperties = applicationProperties;
        this.webSudoManager = webSudoManager;
        this.productLicenseDataProvider = productLicenseDataProvider;
        this.httpsValidator = httpsValidator;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            if (this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey())) {
                SamlConfig samlConfig = this.samlConfigService.getSamlConfig();
                response.setContentType("text/html");
                boolean isDataCenter = this.productLicenseDataProvider.isDataCenterProduct();
                ImmutableMap cfg = new ImmutableMap.Builder().put((Object)"isDataCenter", (Object)isDataCenter).put((Object)"idpType", (Object)samlConfig.getIdpType().toString()).put((Object)"redirectOnLogin", (Object)samlConfig.isRedirectOnLogin()).put((Object)"allowSamlRedirectOverride", (Object)samlConfig.isAllowSamlRedirectOverride()).put((Object)"includeCustomerLogins", (Object)samlConfig.isIncludeCustomerLogins()).put((Object)"ssoIssuer", (Object)ObjectUtils.toString(samlConfig.getSsoIssuer())).put((Object)"certificate", (Object)ObjectUtils.toString(samlConfig.getCertificate())).put((Object)"idpSsoUrl", (Object)ObjectUtils.toString(samlConfig.getIdpSsoUrl())).put((Object)"enableRememberMe", (Object)samlConfig.isEnableRememberMe()).put((Object)"assertionConsumerServiceUrl", (Object)ObjectUtils.toString(samlConfig.getAssertionConsumerUrl())).put((Object)"restEndpointUrl", (Object)(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/rest/authconfig/1.0/saml")).put((Object)"issuer", (Object)Strings.nullToEmpty((String)samlConfig.getIssuer())).put((Object)"isServiceDesk", (Object)this.productLicenseDataProvider.isServiceDeskProduct()).put((Object)"loginUrl", (Object)(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/plugins/servlet/external-login")).put((Object)"skipHttpsRequirement", (Object)(!this.httpsValidator.isHttpsRequired() ? 1 : 0)).put((Object)"baseUrlWithHttps", (Object)this.httpsValidator.isBaseUrlSecure(this.samlConfigService.getSamlConfig())).build();
                this.renderer.render((Appendable)response.getWriter(), "com.atlassian.plugins.authentication.atlassian-authentication-plugin:templates", TEMPLATE_NAME, (Map)cfg);
            } else {
                String target = this.loginUriProvider.getLoginUriForRole(URI.create(URL), UserRole.SYSADMIN).toString();
                logger.info("Redirecting to " + target);
                response.sendRedirect(target);
            }
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }
}

