/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.saml.persistance;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlIdpType;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SamlConfigDAO {
    private static final Logger logger = LoggerFactory.getLogger(SamlConfigDAO.class);
    private final PluginSettingsFactory pluginSettings;
    private final ApplicationProperties applicationProperties;
    public static final String PREFIX = "com.atlassian.plugins.authentication.samlconfig.";
    public static final String SIGNING_CERT = "signing-cert";
    public static final String SSO_SERVICE_URL = "sso-url";
    public static final String SSO_ISSUER = "sso-issuer";
    public static final String IDP_TYPE = "idp-type";
    public static final String USER_ATTRIBUTE = "username-attribute";
    public static final String ALLOW_SAML_REDIRECT_OVERRIDE = "allow-saml-override";
    public static final String INCLUDE_CUSTOMER_LOGINS = "include-customer-logins";
    public static final String REDIRECT_ON_LOGIN = "redirect-on-login";
    public static final String ENABLE_REMEMBER_ME = "enable-remember-me";

    @Inject
    public SamlConfigDAO(@ComponentImport PluginSettingsFactory pluginSettings, @ComponentImport ApplicationProperties applicationProperties) {
        this.pluginSettings = pluginSettings;
        this.applicationProperties = applicationProperties;
    }

    public SamlConfig load() {
        String baseURL = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        if (Strings.isNullOrEmpty((String)baseURL)) {
            logger.info("Base URL is not set - returning empty config");
            return SamlConfig.emptyConfig();
        }
        try {
            return SamlConfig.builder().setSsoIssuer(this.getStringValue(SSO_ISSUER)).setIdpSsoUrl(this.getStringValue(SSO_SERVICE_URL)).setUsernameAttribute(this.getStringValue(USER_ATTRIBUTE)).setCertificate(this.getStringValue(SIGNING_CERT)).setAllowSamlRedirectOverride(this.getBooleanValue(ALLOW_SAML_REDIRECT_OVERRIDE, false)).setIncludeCustomerLogins(this.getBooleanValue(INCLUDE_CUSTOMER_LOGINS, false)).setRedirectOnLogin(this.getBooleanValue(REDIRECT_ON_LOGIN, false)).setEnableRememberMe(this.getBooleanValue(ENABLE_REMEMBER_ME, true)).setAssertionConsumerUrl(new URL(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/plugins/servlet/samlconsumer")).setIssuer(baseURL).setIdpType(Optional.ofNullable(this.getStringValue(IDP_TYPE)).map(SamlIdpType::valueOf).orElse(null)).build();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void remove() {
        Stream.of(SIGNING_CERT, SSO_SERVICE_URL, SSO_ISSUER, USER_ATTRIBUTE, ALLOW_SAML_REDIRECT_OVERRIDE, INCLUDE_CUSTOMER_LOGINS, REDIRECT_ON_LOGIN, ENABLE_REMEMBER_ME, IDP_TYPE).forEach(this::removeValue);
    }

    public void save(SamlConfig samlConfig) {
        this.setStringValue(SSO_ISSUER, samlConfig.getSsoIssuer());
        this.setStringValue(SSO_SERVICE_URL, samlConfig.getIdpSsoUrl());
        this.setStringValue(SIGNING_CERT, samlConfig.getCertificate());
        this.setStringValue(USER_ATTRIBUTE, Strings.emptyToNull((String)samlConfig.getUsernameAttribute()));
        this.setStringValue(ALLOW_SAML_REDIRECT_OVERRIDE, String.valueOf(samlConfig.isAllowSamlRedirectOverride()));
        this.setStringValue(INCLUDE_CUSTOMER_LOGINS, String.valueOf(samlConfig.isIncludeCustomerLogins()));
        this.setStringValue(REDIRECT_ON_LOGIN, String.valueOf(samlConfig.isRedirectOnLogin()));
        this.setStringValue(ENABLE_REMEMBER_ME, String.valueOf(samlConfig.isEnableRememberMe()));
        this.setStringValue(IDP_TYPE, samlConfig.getIdpType().toString());
    }

    private PluginSettings settings() {
        return this.pluginSettings.createGlobalSettings();
    }

    private Object setStringValue(String key, String value) {
        return this.settings().put(PREFIX + key, (Object)value);
    }

    private void removeValue(String key) {
        this.settings().remove(PREFIX + key);
    }

    @Nullable
    private String getStringValue(String key) {
        Object value = this.settings().get(PREFIX + key);
        return value == null ? null : String.valueOf(value);
    }

    private boolean getBooleanValue(String key, boolean defaultValue) {
        String storedValue = this.getStringValue(key);
        return storedValue == null ? defaultValue : Boolean.valueOf(storedValue);
    }
}

