/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.saml;

import com.atlassian.plugins.authentication.impl.config.saml.ErrorReason;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlIdpType;
import com.atlassian.plugins.authentication.impl.config.saml.ValidationUtils;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URL;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class SamlConfigValidator {
    private final HttpsValidator httpsValidator;
    private Iterable<ErrorReason> ERROR_REQUIRED = Collections.singleton(ErrorReason.REQUIRED);
    private Iterable<ErrorReason> ERROR_INCORRECT = Collections.singleton(ErrorReason.INCORRECT);
    private Iterable<ErrorReason> ERROR_INSECURE = Collections.singleton(ErrorReason.INSECURE);
    private Iterable<ErrorReason> NO_ERRORS = Collections.emptyList();

    @Inject
    public SamlConfigValidator(HttpsValidator httpsValidator) {
        this.httpsValidator = httpsValidator;
    }

    public Multimap<String, ErrorReason> validate(SamlConfig samlConfigModel) {
        HashMultimap errorsOnField = HashMultimap.create();
        errorsOnField.putAll((Object)"sso-url", this.validateRequiredField(samlConfigModel.getIdpSsoUrl()));
        errorsOnField.putAll((Object)"sso-issuer", this.validateRequiredField(samlConfigModel.getSsoIssuer()));
        errorsOnField.putAll((Object)"certificate", this.validateRequiredField(samlConfigModel.getCertificate()));
        errorsOnField.putAll((Object)"sso-url", this.validateSsoUrl(samlConfigModel.getIdpSsoUrl()));
        errorsOnField.putAll((Object)"certificate", this.validateCertificate(samlConfigModel.getCertificate()));
        errorsOnField.putAll((Object)"idp-type", this.validateIdpType(samlConfigModel.getIdpType(), samlConfigModel.getIdpSsoUrl()));
        return ImmutableMultimap.copyOf((Multimap)errorsOnField);
    }

    private Iterable<ErrorReason> validateRequiredField(String value) {
        return StringUtils.isEmpty(value) ? this.ERROR_REQUIRED : this.NO_ERRORS;
    }

    private Iterable<? extends ErrorReason> validateIdpType(SamlIdpType idpType, String idpSsoUrl) {
        SamlIdpType inferredType = SamlConfig.inferSamlIdpTypeFromUrl(idpSsoUrl);
        if (inferredType == idpType) {
            return this.NO_ERRORS;
        }
        if (idpType == SamlIdpType.GENERIC && inferredType == SamlIdpType.CROWD) {
            return this.NO_ERRORS;
        }
        return this.ERROR_INCORRECT;
    }

    private Iterable<ErrorReason> validateCertificate(String certificateString) {
        if (!Strings.isNullOrEmpty((String)certificateString)) {
            try {
                ValidationUtils.convertToCertificate(certificateString);
            }
            catch (Exception e) {
                return this.ERROR_INCORRECT;
            }
        }
        return this.NO_ERRORS;
    }

    private Iterable<ErrorReason> validateSsoUrl(String ssoUrl) {
        if (!Strings.isNullOrEmpty((String)ssoUrl)) {
            if (!this.validateUrl(ssoUrl)) {
                return this.ERROR_INCORRECT;
            }
            if (!this.validateUrlIsSecure(ssoUrl)) {
                return this.ERROR_INSECURE;
            }
        }
        return this.NO_ERRORS;
    }

    private boolean validateUrlIsSecure(String ssoUrl) {
        URL url;
        return !this.httpsValidator.isHttpsRequired() || Strings.isNullOrEmpty((String)ssoUrl) || (url = ValidationUtils.convertToUrl(ssoUrl)) == null || "https".equalsIgnoreCase(url.getProtocol());
    }

    private boolean validateUrl(String urlString) {
        if (!Strings.isNullOrEmpty((String)urlString)) {
            try {
                ValidationUtils.convertToUrl(urlString);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

