/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.analytics.events;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.plugins.authentication.impl.analytics.events.AbstractStatusEvent;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlIdpType;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpProviderStatusEvent
extends AbstractStatusEvent {
    private static final Logger log = LoggerFactory.getLogger(IdpProviderStatusEvent.class);

    public IdpProviderStatusEvent(SamlConfig samlConfig, String product) {
        super(samlConfig, product);
    }

    protected String getEventNameSuffix() {
        try {
            URI ssoUri = new URI(this.samlConfig.getIdpSsoUrl());
            if (this.samlConfig.getInferredIdpType() == SamlIdpType.CROWD) {
                return "saml.idp.crowd";
            }
            if (ssoUri.getHost().endsWith("onelogin.com")) {
                return "saml.idp.onelogin";
            }
            if (ssoUri.getHost().endsWith("okta.com") || ssoUri.getHost().endsWith("oktapreview.com")) {
                return "saml.idp.okta";
            }
            if (ssoUri.getHost().endsWith("pingidentity.com")) {
                return "saml.idp.ping";
            }
            if (ssoUri.getHost().endsWith("microsoft.com") || ssoUri.getHost().endsWith("azure.com") || ssoUri.getHost().endsWith("windows.net")) {
                return "saml.idp.azure";
            }
            if (ssoUri.getHost().endsWith("google.com")) {
                return "saml.idp.google";
            }
            if (ssoUri.getPath().startsWith("/adfs")) {
                return "saml.idp.adfs";
            }
        }
        catch (URISyntaxException e) {
            log.warn("Failed parsing provider url");
        }
        return "saml.idp.other";
    }

    @Override
    @EventName
    public String getEventName() {
        return "plugins.authentication.status." + this.getEventNameSuffix();
    }
}

