window.SAMLAuthPlugin = window.SAMLAuthPlugin || {}
window.SAMLAuthPlugin.ConfigForm = window.SAMLAuthPlugin.ConfigForm || function () {
    var self = null;
    return {
        init: function () {
            self = this;
            self.configForm = AJS.$('#configForm');

            self.initializeForm();
            self.initializeCopyButtons();
        },
        cleanup : function () {
            self.clipboard.destroy();
        },
        showFlag: function (type, title, body, autoClose) {
            window.require(['aui/flag'], function (flag) {
                flag({
                    type: type,
                    title: title,
                    close: autoClose ? "auto" : "manual",
                    body: body ? '<p>' + body + '</p>' : null
                });

            });
        },
        initializeCopyButtons: function () {
            self.clipboard = new Clipboard('.idp-copy')
                .on('success', function (e) {
                    self.showFlag('success', AJS.I18n.getText('authentication.copy.success'), null, true);
                }).on('error', function (e) {
                if (/Mac/i.test(navigator.userAgent)) {
                    self.showFlag('info', AJS.I18n.getText('authentication.copy.failed.mac'), null, true);
                } else {
                    self.showFlag('info', AJS.I18n.getText('authentication.copy.failed.others'), null, true);
                }
            });

            AJS.$('.idp-copy').tooltip({gravity: 'w'});
        },
        initializeForm: function () {
            function errorOnFieldTemplate(message) {
                return AJS.template.load('error-on-field-template').fill({message: message}).toString();
            }

            initializeSubmitBehaviour();
            self.hideFormIfAlreadyDisabled(self.configForm.data('dc') && (self.configForm.data('issecurebaseurl') || self.configForm.data('skiphttps')));
            self.initializeRadioButtonsBehaviour();

            function initializeSubmitBehaviour() {
                self.configForm.submit(function (ev) {
                    clearErrors(self.configForm);
                    ev.preventDefault();
                    var newConfig;
                    var isNativeAuthenticationChosen = self.configForm.find('#native-authentication').is(':checked');
                    var method;
                    if (isNativeAuthenticationChosen) {
                        method = 'DELETE';
                        self.clearForm(self.configForm)
                    } else {
                        method = 'PUT';
                        newConfig = loadNewConfiguration(self.configForm);
                    }
                    AJS.$.ajax({
                        type: method,
                        url: self.configForm.attr('action'),
                        contentType: 'application/json',
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('X-Atlassian-Token', 'no-check');
                        },
                        data: JSON.stringify(newConfig),
                        dataType: 'json',
                        accept: 'application/json'
                    })
                        .done(function (data, textStatus, jqXHR) {
                            self.showFlag('success', AJS.I18n.getText('authentication.config.save.success'), null, true);
                        })
                        .fail(function (jqXHR, textStatus, errorThrown) {
                            try {
                                var error = JSON.parse(jqXHR.responseText);
                                if (error.message) {
                                    self.showFlag('error', AJS.I18n.getText('authentication.config.save.fail'), error.message);
                                } else if (error.errors) {
                                    self.showFlag('error', AJS.I18n.getText('authentication.config.save.fail'), AJS.I18n.getText('authentication.config.invalid.error.body'))
                                    for (var key in error.errors) {
                                        for (var i in error.errors[key]) {
                                            addFieldError(key, error.errors[key][i]);
                                        }
                                    }
                                }
                                else {
                                    showFlag('error', AJS.I18n.getText('authentication.config.save.fail'), AJS.I18n.getText('authentication.config.save.fail.unknown.reason'))
                                }
                            } catch (exception) {
                                self.showFlag('error', AJS.I18n.getText('authentication.config.save.fail'), errorThrown);
                            }
                        });
                });

            function addFieldError(fieldId, message) {
                self.configForm.find("#" + fieldId).after(errorOnFieldTemplate(message))
            }

            function loadNewConfiguration() {
                return {
                    'sso-url': self.configForm.find('#sso-url').val().toString(),
                    'redirect-on-login': self.configForm.find('#redirect-on-login').is(':checked'),
                    'certificate': self.configForm.find('#certificate').val(),
                    'include-customer-logins': self.configForm.find('#include-customer-logins').prop("checked"),
                    'sso-issuer': self.configForm.find('#sso-issuer').val().toString(),
                    'enable-remember-me': self.configForm.find('#enable-remember-me').prop("checked")
                };
            }

                function clearErrors() {
                    self.configForm.find('.error').remove();
                }
            }
        },

        hideFormIfAlreadyDisabled: function (shouldBeEnabled) {
            if (!shouldBeEnabled) {
                self.configForm.find('#native-authentication').attr('checked', 'true');
                self.configForm.find('#saml-authentication').attr('disabled', 'true');
                self.configForm.find('#saml-save').attr('disabled', 'true');

                self.setFormEditabilityAndVisibility(false, false);
            }
        },

        initializeRadioButtonsBehaviour: function () {
            self.configForm.find('#native-authentication').change(function () {
                self.setFormEditabilityAndVisibilityIfChecked(AJS.$(this), false)
            });

            self.configForm.find('#saml-authentication').change(function () {
                self.setFormEditabilityAndVisibilityIfChecked(AJS.$(this), true)
            });

            self.configForm.find('#saml-authentication').change();
        },

        setFormEditabilityAndVisibilityIfChecked: function ($radio, visibleIfChecked) {
            var checked = $radio.is(':checked');
            if (!visibleIfChecked) {
                checked = !checked;
            }
            self.setFormEditabilityAndVisibility(checked, checked);
        },

        setFormEditabilityAndVisibility: function (editable, visible) {
            self.configForm.find('#sso-config .disableable').attr('disabled', !editable);
            self.configForm.find('.form-hideable').toggleClass("form-hidden", !visible);
        },
        clearForm : function() {
            self.configForm.find('#sso-config').find('input[type=text]:not([readonly]), textarea').val('');
            self.configForm.find('#include-customer-logins').attr('checked', false);
            self.configForm.find('#allow-saml-redirect-override').attr('checked', false);
            self.configForm.find('#dont-redirect-on-login').attr('checked', true);
            self.configForm.find('#enable-remember-me').attr('checked', false);
        }
    };
}();
AJS.$(function(){window.SAMLAuthPlugin.ConfigForm.init()});

