/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.util;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class HttpsValidator {
    public static final String SKIP_HTTPS_REQUIREMENT_DARKFEATURE = "atlassian.authentication.saml.sso.skip.https.requirement";
    private final DarkFeatureManager darkFeatureManager;

    @Inject
    public HttpsValidator(@ComponentImport DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public boolean isBaseUrlSecure(SamlConfig samlConfig) {
        return this.isBaseUrlHttps(samlConfig) || !this.isHttpsRequired();
    }

    public boolean isHttpsRequired() {
        return !this.darkFeatureManager.isFeatureEnabledForAllUsers(SKIP_HTTPS_REQUIREMENT_DARKFEATURE);
    }

    public boolean isBaseUrlHttps(SamlConfig samlConfig) {
        try {
            return "https".equals(samlConfig.getAssertionConsumerUrl().toURI().getScheme());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

