/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.ui;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.whitelist.InboundWhitelist;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.plugins.whitelist.WhitelistService;
import com.atlassian.plugins.whitelist.ui.WhitelistBean;
import com.atlassian.plugins.whitelist.ui.WhitelistBeanService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.PatternSyntaxException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WhitelistResource {
    private final WhitelistService whitelistService;
    private final I18nResolver i18nResolver;
    private final OutboundWhitelist outboundWhitelist;
    private final InboundWhitelist inboundWhitelist;
    private final WhitelistBeanService whitelistBeanService;

    public WhitelistResource(WhitelistService whitelistService, I18nResolver i18nResolver, OutboundWhitelist outboundWhitelist, InboundWhitelist inboundWhitelist, WhitelistBeanService whitelistBeanService) {
        this.whitelistService = whitelistService;
        this.i18nResolver = i18nResolver;
        this.outboundWhitelist = outboundWhitelist;
        this.inboundWhitelist = inboundWhitelist;
        this.whitelistBeanService = whitelistBeanService;
    }

    @Path(value="enable")
    @POST
    @WebSudoRequired
    public Response enable() {
        this.whitelistService.enableWhitelist();
        return Response.ok().build();
    }

    @Path(value="disable")
    @POST
    @WebSudoRequired
    public Response disable() {
        this.whitelistService.disableWhitelist();
        return Response.ok().build();
    }

    @Path(value="check")
    @GET
    @AnonymousAllowed
    public Response isAllowed(@QueryParam(value="url") String uriString) {
        try {
            URI uri = new URI(uriString);
            return Response.ok((Object)ImmutableMap.of((Object)"outbound", (Object)this.outboundWhitelist.isAllowed(uri), (Object)"inbound", (Object)this.inboundWhitelist.isAllowed(uri))).build();
        }
        catch (URISyntaxException e) {
            return WhitelistResource.error(e.getMessage());
        }
    }

    @POST
    @WebSudoRequired
    public Response create(WhitelistBean whitelistBean) {
        if (whitelistBean.getExpression() == null) {
            return WhitelistResource.fieldError("expression", this.i18nResolver.getText("whitelist.ui.error.noexpression"));
        }
        try {
            WhitelistBean result = this.whitelistBeanService.add(whitelistBean);
            return Response.ok((Object)result).build();
        }
        catch (PatternSyntaxException e) {
            return WhitelistResource.fieldError("expression", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return WhitelistResource.error(e.getMessage());
        }
    }

    @PUT
    @Path(value="{id}")
    @WebSudoRequired
    public Response update(@PathParam(value="id") int id, WhitelistBean whitelistBean) {
        try {
            WhitelistBean result = this.whitelistBeanService.update(id, whitelistBean);
            return Response.ok((Object)result).build();
        }
        catch (NullPointerException e) {
            return WhitelistResource.error(this.i18nResolver.getText("whitelist.ui.error.deleted"));
        }
        catch (IllegalArgumentException e) {
            return WhitelistResource.error(e.getMessage());
        }
    }

    @DELETE
    @Path(value="{id}")
    @WebSudoRequired
    public Response delete(@PathParam(value="id") int id) {
        try {
            this.whitelistService.remove(id);
        }
        catch (NullPointerException e) {
        }
        catch (IllegalArgumentException e) {
            return WhitelistResource.error(e.getMessage());
        }
        return Response.ok().build();
    }

    private static Response fieldError(String field, String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"errors", (Object)ImmutableMap.of((Object)field, (Object)message))).build();
    }

    private static Response error(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"message", (Object)message)).build();
    }
}

