package com.atlassian.plugins.whitelist.ui;

import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;

/**
 * @since 1.1
 */
public class WhitelistBeanBuilder
{
    Integer id;
    String expression;
    WhitelistType type;
    String iconUrl = "";
    boolean allowInbound;

    public WhitelistBeanBuilder from(final WhitelistRule input)
    {
        return id(input.getId())
                .expression(input.getExpression())
                .type(input.getType())
                .allowInbound(input.isAllowInbound());
    }

    public WhitelistBeanBuilder copyOf(final WhitelistBean whitelistBean)
    {
        return id(whitelistBean.getId())
                .expression(whitelistBean.getExpression())
                .type(whitelistBean.getType())
                .iconUrl(whitelistBean.getIconUrl())
                .allowInbound(whitelistBean.isAllowInbound());
    }

    public WhitelistBeanBuilder expression(final String expression)
    {
        this.expression = expression;
        return this;
    }

    public WhitelistBeanBuilder id(final Integer id)
    {
        this.id = id;
        return this;
    }

    public WhitelistBeanBuilder type(final WhitelistType type)
    {
        this.type = type;
        return this;
    }

    public WhitelistBeanBuilder iconUrl(final String iconUrl)
    {
        this.iconUrl = iconUrl;
        return this;
    }

    public WhitelistBeanBuilder allowInbound(final boolean allowInbound)
    {
        this.allowInbound = allowInbound;
        return this;
    }

    public WhitelistBean build()
    {
        return new WhitelistBean(this);
    }
}