package com.atlassian.plugins.whitelist.migration.confluence.macros;

import com.atlassian.plugins.whitelist.WhitelistRule;

import java.util.Collection;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * The processed whitelist data stored in Bandana.
 * @since 1.0
 */
public final class BandanaMacroWhitelistXmlData
{
    private final boolean isAllAllowed;
    private final Collection<WhitelistRule> acceptRules;

    public BandanaMacroWhitelistXmlData(final boolean isAllAllowed, final Collection<WhitelistRule> acceptRules)
    {
        this.isAllAllowed = isAllAllowed;
        this.acceptRules = checkNotNull(acceptRules);
    }

    public boolean isAllAllowed()
    {
        return isAllAllowed;
    }

    public Collection<WhitelistRule> getRules()
    {
        return acceptRules;
    }

    @Override
    public String toString()
    {
        return "BandanaMacroWhitelistXmlData{isAllAllowed=" + isAllAllowed + ", acceptRules=" + acceptRules + '}';
    }
}
