package com.atlassian.plugins.whitelist.migration.confluence;

import com.atlassian.confluence.setup.bandana.BandanaSerializer;
import com.atlassian.confluence.setup.bandana.BandanaSerializerFactory;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;

/**
 * Bridge to use a custom #{@link BandanaSerializer} to deserialize content from Bandana.
 * @since 1.0
 */
public class CustomConfluenceBandanaContext extends ConfluenceBandanaContext implements BandanaSerializerFactory
{
    private BandanaSerializer bandanaSerializer = new RawStringBandanaDeserializer();

    @Override
    public BandanaSerializer getSerializer()
    {
        return bandanaSerializer;
    }
}
