package com.atlassian.plugins.whitelist.matcher;

import com.google.common.base.Predicate;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
public class RegularExpressionMatcher implements Predicate<URI>
{
    private final Pattern pattern;

    public RegularExpressionMatcher(final String expression)
    {
        this.pattern = Pattern.compile(checkNotNull(expression, "expression"));
    }

    @Override
    public boolean apply(final URI uri)
    {
        try
        {
            final URI normalizedUri = MatcherUtils.normalizeUri(uri);
            return pattern.matcher(normalizedUri.toString()).matches();
        }
        catch (URISyntaxException e)
        {
            return false;
        }
    }
}
