/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.http;

import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.joda.time.Duration;
import org.springframework.stereotype.Component;

@Component
public class HttpClientFactory {
    public static final Duration SOCKET_TIMEOUT = Duration.millis((long)Integer.getInteger("remote.event.httpclient.sotimeout.millis", 3000).intValue());
    public static final Duration CONNECTION_TIMEOUT = Duration.millis((long)Integer.getInteger("remote.event.httpclient.conntimeout.millis", 1500).intValue());
    public static final Duration CONNECTION_POOL_TIMEOUT = Duration.millis((long)Integer.getInteger("remote.event.httpclient.pool.timeout.millis", 3600000).intValue());

    public HttpClient createHttpClient() {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient(this.createClientConnectionManager(), this.createParams());
        defaultHttpClient.setRoutePlanner(this.createRoutePlaner());
        defaultHttpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        return defaultHttpClient;
    }

    private ClientConnectionManager createClientConnectionManager() {
        return new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), CONNECTION_POOL_TIMEOUT.getMillis(), TimeUnit.MILLISECONDS);
    }

    private HttpParams createParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        params.setIntParameter("http.socket.timeout", (int)SOCKET_TIMEOUT.getMillis());
        params.setIntParameter("http.connection.timeout", (int)CONNECTION_TIMEOUT.getMillis());
        return params;
    }

    private HttpRoutePlanner createRoutePlaner() {
        return new ProxySelectorRoutePlanner(SchemeRegistryFactory.createDefault(), ProxySelector.getDefault());
    }
}

