/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.diagnostics;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class ProviderStatus {
    private final Iterable<String> errorMessages;
    private final Optional<Boolean> localConfigured;
    private final Optional<Boolean> remoteConfigured;

    private ProviderStatus(Builder builder) {
        this.errorMessages = builder.errorMessages.build();
        this.localConfigured = Optional.ofNullable(builder.localConfigured);
        this.remoteConfigured = Optional.ofNullable(builder.remoteConfigured);
    }

    public Iterable<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Optional<Boolean> getLocalConfigured() {
        return this.localConfigured;
    }

    public Optional<Boolean> getRemoteConfigured() {
        return this.remoteConfigured;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public static class Builder {
        private final ImmutableList.Builder<String> errorMessages = new ImmutableList.Builder();
        private Boolean localConfigured = null;
        private Boolean remoteConfigured = null;

        public Builder addErrorMessage(String ... messages) {
            this.errorMessages.add((Object[])messages);
            return this;
        }

        public Builder setLocalConfigured(Boolean localConfigured) {
            this.localConfigured = localConfigured;
            return this;
        }

        public Builder setRemoteConfigured(Boolean remoteConfigured) {
            this.remoteConfigured = remoteConfigured;
            return this;
        }

        public ProviderStatus build() {
            return new ProviderStatus(this);
        }
    }
}

