/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.BaseFileServerServlet;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.util.LastModifiedHandler;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractDownloadableResource
implements DownloadableResource {
    protected ResourceLocation resourceLocation;
    protected String extraPath;
    protected Plugin plugin;
    protected BaseFileServerServlet servlet;

    public AbstractDownloadableResource(BaseFileServerServlet servlet, Plugin plugin, ResourceLocation resourceLocation, String extraPath) {
        if (extraPath != null && !"".equals(extraPath.trim()) && !resourceLocation.getLocation().endsWith("/")) {
            extraPath = "/" + extraPath;
        }
        this.resourceLocation = resourceLocation;
        this.extraPath = extraPath;
        this.plugin = plugin;
        this.servlet = servlet;
    }

    protected String getContentType() {
        if (this.resourceLocation.getContentType() == null) {
            return this.servlet.getContentType(this.getLocation());
        }
        return this.resourceLocation.getContentType();
    }

    protected String getLocation() {
        return this.resourceLocation.getLocation() + this.extraPath;
    }

    public String toString() {
        return "Resource: " + this.getLocation() + " (" + this.getContentType() + ")";
    }

    public abstract void serveResource(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected boolean checkResourceNotModified(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Date resourceLastModifiedDate = this.plugin.getDateLoaded() == null ? new Date() : this.plugin.getDateLoaded();
        LastModifiedHandler lastModifiedHandler = new LastModifiedHandler(resourceLastModifiedDate);
        return lastModifiedHandler.checkRequest(httpServletRequest, httpServletResponse);
    }
}

