/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.event.impl;

import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.ListenerMethodSelector;
import com.atlassian.plugin.event.impl.MethodNameListenerMethodSelector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginEventManagerImpl
implements PluginEventManager {
    private final Map eventsToListener;
    private static final Log log = LogFactory.getLog((Class)PluginEventManagerImpl.class);
    private final ListenerMethodSelector[] listenerMethodSelectors;

    public PluginEventManagerImpl() {
        this(new ListenerMethodSelector[]{new MethodNameListenerMethodSelector()});
    }

    public PluginEventManagerImpl(ListenerMethodSelector[] selectors) {
        this.listenerMethodSelectors = selectors;
        this.eventsToListener = LazyMap.decorate(new HashMap(), (Factory)new Factory(){

            public Object create() {
                return new HashSet();
            }
        });
    }

    public synchronized void broadcast(Object event) {
        HashSet<Method> calledMethods = new HashSet<Method>();
        HashSet types = new HashSet();
        this.findAllTypes(event.getClass(), types);
        Iterator clsitr = types.iterator();
        while (clsitr.hasNext()) {
            Class type = (Class)clsitr.next();
            Set registrations = (Set)this.eventsToListener.get(type);
            Iterator i = registrations.iterator();
            while (i.hasNext()) {
                ListenerRegistration reg = (ListenerRegistration)i.next();
                try {
                    if (calledMethods.contains(reg.method)) continue;
                    calledMethods.add(reg.method);
                    reg.method.invoke(reg.listener, event);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Unable to access listener method: " + reg.method), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)"Exception calling listener method", e.getCause());
                }
            }
        }
    }

    public synchronized void register(Object listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.forEveryListenerMethod(listener, new ListenerMethodHandler(){

            public void handle(Object listener, Method m) {
                if (m.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Listener methods must only have one argument");
                }
                Set listeners = (Set)PluginEventManagerImpl.this.eventsToListener.get(m.getParameterTypes()[0]);
                listeners.add(new ListenerRegistration(listener, m));
            }
        });
    }

    public synchronized void unregister(Object listener) {
        this.forEveryListenerMethod(listener, new ListenerMethodHandler(){

            public void handle(Object listener, Method m) {
                Set listeners = (Set)PluginEventManagerImpl.this.eventsToListener.get(m.getParameterTypes()[0]);
                listeners.remove(new ListenerRegistration(listener, m));
            }
        });
    }

    void forEveryListenerMethod(Object listener, ListenerMethodHandler handler) {
        Method[] methods = listener.getClass().getMethods();
        for (int x = 0; x < methods.length; ++x) {
            Method m = methods[x];
            for (int s = 0; s < this.listenerMethodSelectors.length; ++s) {
                ListenerMethodSelector selector = this.listenerMethodSelectors[s];
                if (!selector.isListenerMethod(m)) continue;
                handler.handle(listener, m);
            }
        }
    }

    void findAllTypes(Class cls, Set types) {
        if (cls == null) {
            return;
        }
        types.add(cls);
        this.findAllTypes(cls.getSuperclass(), types);
        for (int x = 0; x < cls.getInterfaces().length; ++x) {
            this.findAllTypes(cls.getInterfaces()[x], types);
        }
    }

    private static class ListenerRegistration {
        public final Object listener;
        public final Method method;

        public ListenerRegistration(Object listener, Method method) {
            this.listener = listener;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListenerRegistration that = (ListenerRegistration)o;
            if (!this.listener.equals(that.listener)) {
                return false;
            }
            return this.method.equals(that.method);
        }

        public int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + this.method.hashCode();
            return result;
        }
    }

    private static interface ListenerMethodHandler {
        public void handle(Object var1, Method var2);
    }
}

