/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;

public class Resources
implements Resourced {
    public static final Resources EMPTY_RESOURCES = new Resources(Collections.EMPTY_LIST);
    private List resourceDescriptors;

    public static Resources fromXml(Element element) throws PluginParseException, IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("Cannot parse resources from null XML element");
        }
        List elements = element.elements("resource");
        ArrayList<ResourceDescriptor> templates = new ArrayList<ResourceDescriptor>(elements.size());
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            ResourceDescriptor resourceDescriptor = new ResourceDescriptor((Element)iterator.next());
            if (templates.contains(resourceDescriptor)) {
                throw new PluginParseException("Duplicate resource with type '" + resourceDescriptor.getType() + "' and name '" + resourceDescriptor.getName() + "' found");
            }
            templates.add(resourceDescriptor);
        }
        return new Resources(templates);
    }

    public Resources(List resourceDescriptors) throws IllegalArgumentException {
        if (resourceDescriptors == null) {
            throw new IllegalArgumentException("Resources cannot be created with a null resources list. Pass empty list instead");
        }
        this.resourceDescriptors = resourceDescriptors;
    }

    public List getResourceDescriptors() {
        return this.resourceDescriptors;
    }

    public List getResourceDescriptors(String type) {
        LinkedList<ResourceDescriptor> typedResourceDescriptors = new LinkedList<ResourceDescriptor>();
        Iterator iterator = this.resourceDescriptors.iterator();
        while (iterator.hasNext()) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)iterator.next();
            if (!resourceDescriptor.getType().equalsIgnoreCase(type)) continue;
            typedResourceDescriptors.add(resourceDescriptor);
        }
        return typedResourceDescriptors;
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        Iterator iterator = this.resourceDescriptors.iterator();
        while (iterator.hasNext()) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)iterator.next();
            if (!resourceDescriptor.doesTypeAndNameMatch(type, name)) continue;
            return resourceDescriptor.getResourceLocationForName(name);
        }
        return null;
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        Iterator iterator = this.resourceDescriptors.iterator();
        while (iterator.hasNext()) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)iterator.next();
            if (!resourceDescriptor.getType().equalsIgnoreCase(type) || !resourceDescriptor.getName().equalsIgnoreCase(name)) continue;
            return resourceDescriptor;
        }
        return null;
    }
}

