/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.http;

import com.atlassian.plugin.cache.filecache.Cache;
import com.atlassian.plugin.cache.filecache.impl.PassThroughCache;
import com.atlassian.plugin.servlet.util.LastModifiedHandler;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.helpers.BaseHelpers;
import com.atlassian.plugin.webresource.impl.helpers.Helpers;
import com.atlassian.plugin.webresource.impl.helpers.ResourceServingHelpers;
import com.atlassian.plugin.webresource.impl.http.Router;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.impl.support.LineCountingProxyOutputStream;
import com.atlassian.plugin.webresource.impl.support.NullOutputStream;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.plugin.webresource.impl.support.http.BaseController;
import com.atlassian.plugin.webresource.impl.support.http.Request;
import com.atlassian.plugin.webresource.impl.support.http.Response;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.Util;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;

public class Controller
extends BaseController {
    private final RequestCache requestCache;

    public Controller(Globals globals, Request request, Response response) {
        super(globals, request, response);
        this.requestCache = new RequestCache(globals);
    }

    public void serveResource(String completeKey, String resourceName) {
        LinkedHashSet<String> requiredResources = new LinkedHashSet<String>();
        requiredResources.add(completeKey);
        this.serveResource(requiredResources, Helpers.getResource(this.requestCache, completeKey, resourceName), true, false);
    }

    public void serveResourceSourceMap(String completeKey, String resourceName) {
        if (!this.serveResourceCustomSourceMap(completeKey, resourceName)) {
            LinkedHashSet<String> requiredResources = new LinkedHashSet<String>();
            requiredResources.add(completeKey);
            this.serveSourceMap(requiredResources, Helpers.getResource(this.requestCache, completeKey, resourceName), false);
        }
    }

    private boolean serveResourceCustomSourceMap(String completeKey, String resourceName) {
        String customSourceMapName = resourceName + ".map";
        Resource resource = ResourceServingHelpers.getResource(this.requestCache, completeKey, customSourceMapName);
        if (resource != null) {
            Content content = resource.getContent();
            String contentType = content.getContentType() != null ? content.getContentType() : this.request.getContentType();
            this.response.setContentTypeIfNotBlank(contentType);
            content.writeTo(this.response.getOutputStream(), false);
            return true;
        }
        return false;
    }

    public void serveBatch(final Collection<String> included, final LinkedHashSet<String> excluded, final String type, final boolean resolveDependencies, final boolean withLegacyConditions, boolean isCachingEnabled) {
        this.serveResources(new LinkedHashSet<String>(included), new Supplier<Collection<Resource>>(){

            public Collection<Resource> get() {
                return Controller.this.getBatchResources(included, excluded, type, resolveDependencies, withLegacyConditions);
            }
        }, isCachingEnabled);
    }

    public void serveBatchSourceMap(final Collection<String> included, final LinkedHashSet<String> excluded, final String type, final boolean resolveDependencies, final boolean withLegacyConditions) {
        this.serveResourcesSourceMap(new LinkedHashSet<String>(included), new Supplier<Collection<Resource>>(){

            public Collection<Resource> get() {
                return Controller.this.getBatchResources(included, excluded, type, resolveDependencies, withLegacyConditions);
            }
        });
    }

    protected List<Resource> getBatchResources(Collection<String> included, LinkedHashSet<String> excluded, String type, boolean resolveDependencies, boolean withLegacyConditions) {
        return this.requestCache.getSnapshot().find().included(included).excluded(excluded, BaseHelpers.isConditionsSatisfied(this.requestCache, this.request.getParams())).deep(resolveDependencies).deepFilter(BaseHelpers.isConditionsSatisfied(this.requestCache, this.request.getParams())).deepFilter((Predicate<Bundle>)(withLegacyConditions ? Predicates.alwaysTrue() : Predicates.not(BaseHelpers.hasLegacyCondition()))).resources(this.requestCache).filter(ResourceServingHelpers.shouldBeIncludedInBatch(type, this.request.getParams())).end();
    }

    public void serveResourceRelativeToBatch(Collection<String> included, LinkedHashSet<String> excluded, String resourceName, boolean resolveDependencies, boolean withLegacyConditions) {
        this.serveResource(new LinkedHashSet<String>(included), this.getResourceRelativeToBatch(included, excluded, resourceName, resolveDependencies, withLegacyConditions), true, false);
    }

    public void serveResourceRelativeToBatchSourceMap(Collection<String> included, LinkedHashSet<String> excluded, String resourceName, boolean resolveDependencies, boolean withLegacyConditions) {
        this.serveSourceMap(new LinkedHashSet<String>(included), this.getResourceRelativeToBatch(included, excluded, resourceName, resolveDependencies, withLegacyConditions), false);
    }

    protected Resource getResourceRelativeToBatch(Collection<String> included, LinkedHashSet<String> excluded, String resourceName, boolean resolveDependencies, boolean withLegacyConditions) {
        List<String> bundles = this.requestCache.getSnapshot().find().included(included).excluded(excluded, BaseHelpers.isConditionsSatisfied(this.requestCache, this.request.getParams())).deep(resolveDependencies).deepFilter(BaseHelpers.isConditionsSatisfied(this.requestCache, this.request.getParams())).deepFilter((Predicate<Bundle>)(withLegacyConditions ? Predicates.alwaysTrue() : Predicates.not(BaseHelpers.hasLegacyCondition()))).end();
        return Helpers.getResource(this.requestCache, bundles, resourceName);
    }

    public void serveSource(String completeKey, String resourceName) {
        LinkedHashSet<String> requiredResources = new LinkedHashSet<String>();
        requiredResources.add(completeKey);
        this.serveResource(requiredResources, Helpers.getResource(this.requestCache, completeKey, resourceName), false, false);
    }

    protected void serveResource(LinkedHashSet<String> requiredResources, Resource resource, boolean applyTransformations, boolean isCachingEnabled) {
        if (this.handleNotFoundRedirectAndNotModified(resource)) {
            return;
        }
        Content content = applyTransformations ? Helpers.transform(this.globals, requiredResources, this.request.getUrl(), resource, this.request.getParams(), true) : resource.getContent();
        this.sendCached(content, isCachingEnabled);
    }

    protected void serveResources(LinkedHashSet<String> requiredResources, Supplier<Collection<Resource>> resources, boolean isCachingEnabled) {
        String type = this.request.getType();
        Content content = Helpers.transform(this.globals, requiredResources, this.request.getUrl(), type, resources, this.request.getParams());
        this.sendCached(content, isCachingEnabled);
    }

    protected void serveSourceMap(LinkedHashSet<String> requiredResources, Resource resource, boolean isCachingEnabled) {
        if (this.handleNotFoundRedirectAndNotModified(resource)) {
            return;
        }
        Content content = Helpers.transform(this.globals, requiredResources, Router.sourceMapUrlToUrl(this.request.getUrl()), resource, this.request.getParams(), true);
        this.sendCached(content, isCachingEnabled);
    }

    private void serveResourcesSourceMap(LinkedHashSet<String> requiredResources, Supplier<Collection<Resource>> resources) {
        String resourcePath = Router.sourceMapUrlToUrl(this.request.getPath());
        String type = Request.getType(resourcePath);
        Content content = Helpers.transform(this.globals, requiredResources, Router.sourceMapUrlToUrl(this.request.getUrl()), type, resources, this.request.getParams());
        this.sendCached(content, true);
    }

    protected boolean handleNotFoundRedirectAndNotModified(Resource resource) {
        if (resource == null) {
            this.response.sendError(404);
            return true;
        }
        if (this.checkIfCachedAndNotModified(resource.getParent().getUpdatedAt())) {
            return true;
        }
        if (resource.isRedirect()) {
            this.response.sendRedirect(resource.getLocation(), resource.getContentType());
            return true;
        }
        return false;
    }

    protected boolean checkIfCachedAndNotModified(Date updatedAt) {
        LastModifiedHandler lastModifiedHandler = new LastModifiedHandler(updatedAt);
        return this.request.isCacheable() && lastModifiedHandler.checkRequest(this.request.getOriginalRequest(), this.response.getOriginalResponse());
    }

    protected void sendCached(Content content, boolean isCachingEnabled) {
        if (this.isSourceMapEnabled() && content.isTransformed() && this.globals.getConfig().optimiseSourceMapsForDevelopment()) {
            this.sendCachedInDevelopment(content, isCachingEnabled);
        } else {
            this.sendCachedInProduction(content, isCachingEnabled);
        }
    }

    protected void sendCachedInProduction(final Content content, boolean isCachingEnabled) {
        String contentType = content.getContentType() != null ? content.getContentType() : this.request.getContentType();
        this.response.setContentTypeIfNotBlank(contentType);
        PassThroughCache cache = isCachingEnabled && this.request.isCacheable() ? this.globals.getContentCache() : new PassThroughCache();
        String cacheKey = this.buildCacheKey(this.request.getUrl());
        if (Router.isSourceMap(this.request)) {
            if (this.globals.getConfig().isSourceMapEnabled()) {
                cache.cache("http", cacheKey, this.response.getOutputStream(), new Cache.StreamProvider(){

                    @Override
                    public void write(OutputStream producerOut) {
                        LineCountingProxyOutputStream lineCountingStream = new LineCountingProxyOutputStream(new NullOutputStream());
                        SourceMap sourceMap = content.writeTo(lineCountingStream, true);
                        if (sourceMap == null) {
                            String resourceUrl = Router.sourceMapUrlToUrl(Controller.this.request.getUrl());
                            sourceMap = Util.create1to1SourceMap((int)lineCountingStream.getLinesCount(), (String)resourceUrl);
                        }
                        try {
                            producerOut.write(sourceMap.generate().getBytes());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                this.response.sendError(503);
            }
        } else {
            cache.cache("http", cacheKey, this.response.getOutputStream(), new Cache.StreamProvider(){

                @Override
                public void write(OutputStream producerOut) {
                    content.writeTo(producerOut, false);
                }
            });
            if (this.isSourceMapEnabled() && content.isTransformed()) {
                String sourceMapUrl = this.globals.getRouter().sourceMapUrl(this.request.getPath(), this.request.getParams());
                try {
                    this.response.getOutputStream().write(("\n" + Util.generateSourceMapComment((String)sourceMapUrl, (String)contentType)).getBytes());
                }
                catch (IOException | RuntimeException e) {
                    Support.LOGGER.error("can't generate source map comment", (Throwable)e);
                }
            }
        }
    }

    protected void sendCachedInDevelopment(final Content content, boolean isCachingEnabled) {
        String cacheKey;
        String resourceContentType;
        PassThroughCache cache;
        String contentType = content.getContentType() != null ? content.getContentType() : this.request.getContentType();
        this.response.setContentTypeIfNotBlank(contentType);
        Cache cache2 = cache = isCachingEnabled && this.request.isCacheable() ? this.globals.getContentCache() : new PassThroughCache();
        if (Router.isSourceMap(this.request)) {
            String resourcePath = Router.sourceMapUrlToUrl(this.request.getPath());
            resourceContentType = content.getContentType() != null ? content.getContentType() : this.globals.getConfig().getContentType(resourcePath);
            cacheKey = this.buildCacheKey(Router.sourceMapUrlToUrl(this.request.getUrl()));
        } else {
            resourceContentType = contentType;
            cacheKey = this.buildCacheKey(this.request.getUrl());
        }
        Cache.TwoStreamProvider twoStreamProvider = new Cache.TwoStreamProvider(){

            @Override
            public void write(OutputStream out1, OutputStream out2) {
                LineCountingProxyOutputStream lineCountingStream = new LineCountingProxyOutputStream(out1);
                SourceMap sourceMap = content.writeTo(lineCountingStream, true);
                String sourceMapUrl = Controller.this.globals.getRouter().sourceMapUrl(Controller.this.request.getPath(), Controller.this.request.getParams());
                try {
                    out1.write(("\n" + Util.generateSourceMapComment((String)sourceMapUrl, (String)resourceContentType)).getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (sourceMap == null) {
                    String resourceUrl = Router.sourceMapUrlToUrl(Controller.this.request.getUrl());
                    sourceMap = Util.create1to1SourceMap((int)lineCountingStream.getLinesCount(), (String)resourceUrl);
                }
                try {
                    out2.write(sourceMap.generate().getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        OutputStream out = this.response.getOutputStream();
        if (Router.isSourceMap(this.request)) {
            cache.cacheTwo("http", cacheKey, null, out, twoStreamProvider);
        } else {
            cache.cacheTwo("http", cacheKey, out, null, twoStreamProvider);
        }
    }

    protected String buildCacheKey(String url) {
        return url + "&_isMinificationEnabled=" + this.globals.getConfig().isMinificationEnabled();
    }

    protected boolean isSourceMapEnabled() {
        String resourcePath = "map".equals(this.request.getType()) ? Router.sourceMapUrlToUrl(this.request.getPath()) : this.request.getPath();
        String type = Request.getType(resourcePath);
        return this.globals.getConfig().isSourceMapEnabledFor(type);
    }
}

