/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssemblerBuilder;
import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.CachedTransformers;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerBuilder;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.webresource.api.prebake.Dimensions;

public class DefaultWebResourceAssemblerFactory
implements PrebakeWebResourceAssemblerFactory {
    private final Globals globals;

    public DefaultWebResourceAssemblerFactory(Globals globals) {
        this.globals = globals;
    }

    public DefaultWebResourceAssemblerFactory(PluginResourceLocator pluginResourceLocator) {
        this(pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt());
    }

    @Override
    public PrebakeWebResourceAssemblerBuilder create() {
        return new DefaultWebResourceAssemblerBuilder(this.globals);
    }

    @Override
    public Dimensions computeDimensions() {
        Snapshot snapshot = this.globals.getSnapshot();
        Dimensions d = Dimensions.empty();
        for (CachedCondition condition : snapshot.conditions()) {
            d = d.product(condition.computeDimensions());
        }
        for (CachedTransformers transformer : snapshot.transformers()) {
            d = d.product(transformer.computeDimensions(this.globals.getConfig().getTransformerCache()));
        }
        StaticTransformers staticTransformers = this.globals.getConfig().getStaticTransformers();
        d = d.product(staticTransformers.computeDimensions());
        return d;
    }

    @Override
    public String computeGlobalStateHash() {
        return this.globals.getConfig().computeGlobalStateHash();
    }

    @Deprecated
    public void clearCache() {
        this.globals.triggerStateChange();
    }
}

