/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractWebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CssWebResource
extends AbstractWebResourceFormatter {
    public static final WebResourceFormatter FORMATTER = new CssWebResource();
    private static final String CSS_EXTENSION = ".css";
    private static final String LESS_EXTENSION = ".less";
    private static final List<String> HANDLED_PARAMETERS = Arrays.asList("title", "media", "charset", "data-wrm-key", "data-wrm-batch-type");

    @Override
    public boolean matches(String name) {
        return name != null && (name.endsWith(CSS_EXTENSION) || name.endsWith(LESS_EXTENSION));
    }

    @Override
    public String formatResource(String url, Map<String, String> attributes) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"");
        buffer.append(StringEscapeUtils.escapeHtml((String)url)).append("\"");
        List<String> attributeTokens = this.getParametersAsAttributes(attributes);
        if (attributes != null && attributes.size() > 0) {
            buffer.append(" ").append(StringUtils.join(attributeTokens.iterator(), (String)" "));
        }
        if (!attributes.containsKey("media")) {
            buffer.append(" media=\"all\"");
        }
        buffer.append(">\n");
        if (attributes.containsKey("conditionalComment")) {
            String condition = attributes.get("conditionalComment");
            buffer.insert(0, "<!--[if " + condition + "]>\n");
            buffer.append("<![endif]-->\n");
        } else if (BooleanUtils.toBoolean((String)attributes.get("ieonly"))) {
            buffer.insert(0, "<!--[if IE]>\n");
            buffer.append("<![endif]-->\n");
        }
        return buffer.toString();
    }

    @Override
    protected List<String> getAttributeParameters() {
        return HANDLED_PARAMETERS;
    }
}

