/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.ContextBatchPluginResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceBatchParams;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.TransformDescriptorToKey;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextBatch {
    private static Logger log = LoggerFactory.getLogger(ContextBatch.class);
    private static final String UTF8 = "UTF-8";
    private static final String MD5 = "MD5";
    private static final Ordering<ModuleDescriptor<?>> MODULE_KEY_ORDERING = Ordering.natural().onResultOf((Function)new TransformDescriptorToKey());
    private final String key;
    private final Iterable<String> contexts;
    private final Iterable<WebResourceModuleDescriptor> resources;
    private final Iterable<String> resourceKeys;
    private final Set<PluginResourceBatchParams> resourceParams;

    static ContextBatch merge(ContextBatch b1, ContextBatch b2) {
        String key = b1.getKey() + "," + b2.getKey();
        Iterable contexts = Iterables.concat(b1.getContexts(), b2.getContexts());
        Iterable resources = Iterables.concat(b1.getResources(), b2.getResources());
        Iterable params = Iterables.concat(b1.getResourceParams(), b2.getResourceParams());
        return new ContextBatch(key, contexts, resources, params);
    }

    ContextBatch(String context, Iterable<WebResourceModuleDescriptor> resources) {
        this(context, (Iterable<String>)ImmutableList.of((Object)context), resources, (Iterable<PluginResourceBatchParams>)ImmutableList.of());
    }

    ContextBatch(String key, Iterable<String> contexts, Iterable<WebResourceModuleDescriptor> resources, Iterable<PluginResourceBatchParams> resourceParams) {
        this.key = key;
        this.contexts = ImmutableList.copyOf(contexts);
        this.resourceParams = Sets.newHashSet(resourceParams);
        this.resources = ImmutableSortedSet.copyOf(MODULE_KEY_ORDERING, resources);
        this.resourceKeys = Iterables.transform(resources, (Function)new TransformDescriptorToKey());
    }

    boolean isResourceIncluded(String resourceModuleKey) {
        return Iterables.contains(this.resourceKeys, (Object)resourceModuleKey);
    }

    void addResourceType(PluginResource pluginResource) {
        HashMap<String, String> parameters = new HashMap<String, String>(PluginResourceLocator.BATCH_PARAMS.length);
        String type = ResourceUtils.getType(pluginResource.getResourceName());
        for (String key : PluginResourceLocator.BATCH_PARAMS) {
            if (pluginResource.getParams().get(key) == null) continue;
            parameters.put(key, pluginResource.getParams().get(key));
        }
        this.resourceParams.add(new PluginResourceBatchParams(type, parameters));
    }

    Iterable<PluginResource> buildPluginResources() {
        final String hash = this.createHash();
        return Iterables.transform(this.resourceParams, (Function)new Function<PluginResourceBatchParams, PluginResource>(){

            public PluginResource apply(PluginResourceBatchParams param) {
                return new ContextBatchPluginResource(ContextBatch.this.key, (Iterable<String>)ContextBatch.this.contexts, hash, param.getType(), param.getParameters());
            }
        });
    }

    private String createHash() {
        try {
            MessageDigest md5 = MessageDigest.getInstance(MD5);
            for (WebResourceModuleDescriptor moduleDescriptor : this.resources) {
                String version = moduleDescriptor.getPlugin().getPluginInformation().getVersion();
                md5.update(moduleDescriptor.getCompleteKey().getBytes(UTF8));
                md5.update(version.getBytes(UTF8));
            }
            return new String(Hex.encodeHex((byte[])md5.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"MD5 hashing algorithm is not available.");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 encoding is not available.");
        }
    }

    String getKey() {
        return this.key;
    }

    Iterable<String> getContexts() {
        return this.contexts;
    }

    Iterable<WebResourceModuleDescriptor> getResources() {
        return this.resources;
    }

    Iterable<PluginResourceBatchParams> getResourceParams() {
        return Collections.unmodifiableSet(this.resourceParams);
    }
}

