/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourceModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private List<String> dependencies = Collections.emptyList();
    private boolean disableMinification;
    private Set<String> contexts = Collections.emptySet();
    private List<WebResourceTransformation> webResourceTransformations = Collections.emptyList();

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        ArrayList<String> deps = new ArrayList<String>();
        for (Element dependency : element.elements("dependency")) {
            deps.add(dependency.getTextTrim());
        }
        this.dependencies = Collections.unmodifiableList(deps);
        HashSet<String> ctxs = new HashSet<String>();
        for (Element contextElement : element.elements("context")) {
            ctxs.add(contextElement.getTextTrim());
        }
        this.contexts = Collections.unmodifiableSet(ctxs);
        ArrayList<WebResourceTransformation> trans = new ArrayList<WebResourceTransformation>();
        for (Element e : element.elements("transformation")) {
            trans.add(new WebResourceTransformation(e));
        }
        this.webResourceTransformations = Collections.unmodifiableList(trans);
        Attribute minifiedAttribute = element.attribute("disable-minification");
        this.disableMinification = minifiedAttribute == null ? false : Boolean.valueOf(minifiedAttribute.getValue());
    }

    public Void getModule() {
        throw new UnsupportedOperationException("There is no module for Web Resources");
    }

    public Set<String> getContexts() {
        return this.contexts;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<WebResourceTransformation> getTransformations() {
        return this.webResourceTransformations;
    }

    public boolean isDisableMinification() {
        return this.disableMinification;
    }
}

