/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.cdn.mapper.DefaultMapping;
import com.atlassian.plugin.webresource.cdn.mapper.DefaultMappingSet;
import com.atlassian.plugin.webresource.cdn.mapper.Mapping;
import com.atlassian.plugin.webresource.cdn.mapper.MappingParser;
import com.atlassian.plugin.webresource.cdn.mapper.MappingSet;
import com.atlassian.plugin.webresource.impl.PrebakeErrorFactory;
import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import com.atlassian.webresource.plugin.prebake.discovery.CrawlerResult;
import com.atlassian.webresource.plugin.prebake.discovery.PreBakeState;
import com.atlassian.webresource.plugin.prebake.discovery.TaintedResource;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceBatch;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceCrawler;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourcePreBaker;
import com.atlassian.webresource.plugin.prebake.exception.PreBakeIOException;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import com.atlassian.webresource.plugin.prebake.resources.ResourceCollector;
import com.atlassian.webresource.plugin.prebake.resources.ResourceContent;
import com.atlassian.webresource.plugin.prebake.util.FileUtil;
import com.atlassian.webresource.plugin.prebake.util.PreBakeUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryTask.class);
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#0.00");
    private final WebResourcePreBaker preBaker;
    private final WebResourceBatch batch;
    private final List<WebResourceCrawler> crawlers;
    private final ResourceCollector resourceCollector;

    public DiscoveryTask(WebResourcePreBaker preBaker, WebResourceBatch batch, List<WebResourceCrawler> crawlers, ResourceCollector resourceCollector) {
        this.preBaker = preBaker;
        this.batch = batch;
        this.crawlers = crawlers;
        this.resourceCollector = resourceCollector;
    }

    private void doRun() throws Exception {
        try {
            Path path = Paths.get(this.preBaker.getBundleDir().getPath(), this.batch.getVersion());
            FileUtils.deleteDirectory((File)path.toFile());
        }
        catch (IOException e) {
            throw new PreBakeIOException("Problem during clearing previous results", e);
        }
        String resourcesDir = this.preBaker.getBundleDir().getPath() + PreBakeUtil.SEPRTR + this.batch.getVersion() + PreBakeUtil.SEPRTR;
        String bundleZip = resourcesDir + "bundle.zip";
        String bundleDir = resourcesDir + PreBakeUtil.BUNDLE_ZIP_DIR;
        String relativeState = bundleDir + "state.txt";
        String relativeMappings = bundleDir + "mappings.json";
        String relativeResources = bundleDir + PreBakeUtil.RELATIVE_RESOURCES;
        String prebakeReport = bundleDir + "report.txt";
        if (Paths.get(relativeResources, new String[0]).toFile().mkdirs()) {
            log.trace("Creating new directory: {}", (Object)relativeResources);
        }
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        if (CollectionUtils.isNotEmpty(this.crawlers)) {
            this.crawlers.forEach(c -> resources.addAll(c.get()));
        }
        CrawlerResult cr = this.collectAll(resources, relativeResources);
        this.batch.addCrawlerResult(cr);
        try {
            FileUtil.write2File(this.batch.getVersion().getBytes("UTF-8"), new File(relativeState));
            FileUtil.write2File(new MappingParser().getAsString(this.batch.getMappings()).getBytes("UTF-8"), new File(relativeMappings));
            this.writeBatchReport(this.batch, prebakeReport);
            Set<String> sources = StreamSupport.stream(this.batch.getMappings().all().spliterator(), false).map(Mapping::mappedResources).flatMap(Collection::stream).map(h -> relativeResources + h).sorted().collect(Collectors.toSet());
            sources.add(relativeState);
            sources.add(relativeMappings);
            sources.add(prebakeReport);
            FileUtil.zipFiles(new File(resourcesDir), sources, bundleZip);
        }
        catch (IOException e) {
            throw new PreBakeIOException(String.format("Problem during %s creation", bundleZip), e);
        }
    }

    private CrawlerResult collectAll(Set<Resource> resources, String resourcesDir) {
        LinkedHashSet<Mapping> mappings = new LinkedHashSet<Mapping>();
        ArrayList<TaintedResource> taintedResources = new ArrayList<TaintedResource>();
        for (Resource res : resources) {
            this.collect(res, resourcesDir, mappings, taintedResources);
        }
        return new CrawlerResult((MappingSet)new DefaultMappingSet(mappings), taintedResources);
    }

    private void collect(Resource res, String resourcesDir, Set<Mapping> mappings, List<TaintedResource> taintedResources) {
        if (!this.preBaker.isCSSPrebakingEnabled() && res.getExtension().equals(".css")) {
            return;
        }
        String url = res.getUrl();
        String fullName = res.getName();
        String relativeUrl = this.preBaker.relativeUrl(url);
        URI uri = this.preBaker.toURI(url);
        if (res.isTainted()) {
            log.warn(String.format("Encountered tainted resource: %s", url));
            taintedResources.add(new TaintedResource(url, fullName, res.getPrebakeErrors()));
            return;
        }
        try {
            ResourceContent rc = this.resourceCollector.collect(uri);
            byte[] content = rc.getContent();
            String fileName = "/" + PreBakeUtil.hash(content) + res.getExtension();
            Path target = Paths.get(resourcesDir, fileName);
            if (!Files.exists(target, new LinkOption[0])) {
                ByteArrayInputStream is = new ByteArrayInputStream(content);
                Files.copy(is, target, new CopyOption[0]);
                ((InputStream)is).close();
            }
            DefaultMapping mapping = new DefaultMapping(relativeUrl, Stream.of(fileName));
            mappings.add((Mapping)mapping);
        }
        catch (PreBakeIOException | IOException e) {
            String msg = String.format("Could not fetch resource: %s", url);
            log.error(msg, (Throwable)e);
            PrebakeError pe = PrebakeErrorFactory.from((String)msg, (Throwable)e);
            taintedResources.add(new TaintedResource(url, fullName, pe));
        }
    }

    private void writeBatchReport(WebResourceBatch batch, String filename) throws IOException {
        int taintCount;
        FileWriter fw = new FileWriter(filename);
        BufferedWriter bw = new BufferedWriter(fw);
        List<TaintedResource> trs = batch.getTaintedResources();
        int mapCount = batch.getMappings().size();
        int total = mapCount + (taintCount = trs.size());
        double coverage = total == 0 ? 0.0 : (double)mapCount / (double)total * 100.0;
        bw.append("Coverage: ").append(PERCENT_FORMAT.format(coverage)).append("%\n");
        bw.append("Baked resources: ").append(String.valueOf(mapCount)).append("\n");
        bw.append("Tainted resources: ").append(String.valueOf(taintCount)).append("\n");
        for (TaintedResource tr : trs) {
            bw.append("\nRESOURCE: ");
            bw.append(tr.getUrl());
            bw.append("\n");
            int i = 0;
            for (PrebakeError pe : tr.getPrebakeErrors()) {
                bw.append(String.valueOf(i)).append(") ");
                bw.append(pe.toString());
                bw.append("\n");
            }
        }
        bw.close();
        fw.close();
    }

    @Override
    public final void run() {
        this.preBaker.setState(PreBakeState.RUNNING);
        boolean cancelled = false;
        try {
            this.doRun();
            this.preBaker.setState(cancelled ? PreBakeState.CANCELLED : PreBakeState.DONE);
        }
        catch (Exception e) {
            try {
                cancelled = true;
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.preBaker.setState(cancelled ? PreBakeState.CANCELLED : PreBakeState.DONE);
                throw throwable;
            }
        }
    }
}

