/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.cdn.mapper.DefaultMappingSet;
import com.atlassian.plugin.webresource.cdn.mapper.Mapping;
import com.atlassian.plugin.webresource.cdn.mapper.MappingSet;
import com.atlassian.webresource.plugin.prebake.discovery.CrawlerResult;
import com.atlassian.webresource.plugin.prebake.discovery.TaintedResource;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceBatch;
import com.atlassian.webresource.plugin.prebake.util.PreBakeUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DefaultWebResourceBatch
implements WebResourceBatch {
    private final String version;
    private final String bundle;
    private final LinkedHashSet<Mapping> mappings = new LinkedHashSet();
    private final List<TaintedResource> taintedResources = new ArrayList<TaintedResource>();

    public DefaultWebResourceBatch(String version) {
        this.version = version;
        this.bundle = version + PreBakeUtil.SEPRTR + "bundle.zip";
    }

    @Override
    public final String getVersion() {
        return this.version;
    }

    @Override
    public String getBundle() {
        return this.bundle;
    }

    @Override
    public final MappingSet getMappings() {
        return new DefaultMappingSet(this.mappings);
    }

    @Override
    public void addCrawlerResult(CrawlerResult cr) {
        cr.getMappingSet().all().spliterator().forEachRemaining(this.mappings::add);
        this.taintedResources.addAll(cr.getTaintedResources());
    }

    @Override
    public List<TaintedResource> getTaintedResources() {
        return ImmutableList.copyOf(this.taintedResources);
    }
}

