package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssembler;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.webresource.plugin.prebake.resources.Resource;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * A {@link WebResourceCrawler} that collects the resource urls associated with the superbatch.
 *
 * @since v3.5.0
 */
public final class SuperBatchCrawler implements WebResourceCrawler {

    private final PrebakeWebResourceAssemblerFactory assemblerFactory;

    public SuperBatchCrawler(PrebakeWebResourceAssemblerFactory assemblerFactory) {
        this.assemblerFactory = assemblerFactory;
    }

    @Override
    public Set<Resource> get() {
        Set<Resource> resources = new LinkedHashSet<>();

        Dimensions dims = assemblerFactory.computeDimensions();
        dims.cartesianProduct().forEach(coord -> {
            PrebakeWebResourceAssembler assembler = assemblerFactory.create().withCoordinate(coord).build();
            crawlAssembledResource(assembler.assembled(), resources);
        });

        return resources;
    }

}
