package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.impl.snapshot.RootPage;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.webresource.plugin.prebake.resources.Resource;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * A {@link WebResourceCrawler} that collects all resource urls accessible from a series of {@code <root-page>}s.
 *
 * @since v3.5.9
 */
public final class RootPageCrawler implements WebResourceCrawler {

    private final PrebakeWebResourceAssemblerFactory assemblerFactory;
    private final Iterable<RootPage> rootPages;

    public RootPageCrawler(PrebakeWebResourceAssemblerFactory assemblerFactory, Iterable<RootPage> rootPages) {
        this.rootPages = rootPages;
        this.assemblerFactory = assemblerFactory;
    }

    @Override
    public Set<Resource> get() {
        Set<Resource> resources = new LinkedHashSet<>();

        Dimensions dims = assemblerFactory.computeDimensions();
        for (RootPage rp : rootPages) {
            dims.cartesianProduct().forEach(coord -> {
                WebResourceAssembler assembler = createAssembler(rp, coord, assemblerFactory);
                crawlAssembledResource(assembler.assembled(), resources);
            });
        }

        return resources;
    }

    private WebResourceAssembler createAssembler(
            RootPage page,
            Coordinate coord,
            PrebakeWebResourceAssemblerFactory fct) {
        return fct
                .create()
                .withCoordinate(coord)
                .includePage(page.getWebResource().getKey())
                .build();
    }

}
