/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.Plugin;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginServletContextWrapper
implements ServletContext {
    private final Plugin plugin;
    private final ServletContext context;
    private final ConcurrentMap<String, Object> attributes;
    private final Map<String, String> initParams;
    private final Method methodGetContextPath;

    public PluginServletContextWrapper(Plugin plugin, ServletContext context, ConcurrentMap<String, Object> attributes, Map<String, String> initParams) {
        Method tmpMethod = null;
        this.plugin = plugin;
        this.context = context;
        this.attributes = attributes;
        this.initParams = initParams;
        Class<?> cls = context.getClass();
        try {
            tmpMethod = cls.getMethod("getContextPath", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        this.methodGetContextPath = tmpMethod;
    }

    public Object getAttribute(String name) {
        Object attr = this.attributes.get(name);
        if (attr == null) {
            attr = this.context.getAttribute(name);
        }
        return attr;
    }

    public Enumeration getAttributeNames() {
        HashSet<Object> names = new HashSet<Object>();
        names.addAll(this.attributes.keySet());
        names.addAll(Collections.list(this.context.getAttributeNames()));
        return Collections.enumeration(names);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public String getInitParameter(String name) {
        return this.initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.initParams.keySet());
    }

    public URL getResource(String path) throws MalformedURLException {
        URL url = this.plugin.getResource(path);
        if (url == null) {
            url = this.context.getResource(path);
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        InputStream in = this.plugin.getResourceAsStream(path);
        if (in == null) {
            in = this.context.getResourceAsStream(path);
        }
        return in;
    }

    public ServletContext getContext(String uripath) {
        return null;
    }

    public String getContextPath() {
        if (this.methodGetContextPath != null) {
            try {
                return (String)this.methodGetContextPath.invoke((Object)this.context, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot access this method", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Unable to execute getContextPath()", e.getCause());
            }
        }
        throw new UnsupportedOperationException("This servlet context doesn't support 2.5 methods");
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    public Set getResourcePaths(String arg0) {
        return this.context.getResourcePaths(arg0);
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.context.getServlet(name);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    public Enumeration getServletNames() {
        return this.context.getServletNames();
    }

    public Enumeration getServlets() {
        return this.context.getServlets();
    }

    public void log(Exception exception, String msg) {
        this.context.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    public void log(String msg) {
        this.context.log(msg);
    }
}

