/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test.servlet;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugins.osgi.test.BundleTestClassesManager;
import com.atlassian.plugins.osgi.test.OsgiTestClassLoader;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Bundle;

public class TestConsoleServlet
extends HttpServlet {
    static final String JIRA_SERAPH_SECURITY_ORIGINAL_URL = "os_security_originalurl";
    static final String CONF_SERAPH_SECURITY_ORIGINAL_URL = "seraph_originalurl";
    public static final String CONSOLE_TEMPLATE = "/templates/it-test-console.vm";
    public static final String BUNDLE_TEMPLATE = "/templates/it-test-bundles.vm";
    public static final String ERROR_TEMPLATE = "/templates/it-test-error.vm";
    public static final String BUNDLE_PARAM = "bundle";
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final OsgiTestClassLoader testLoader;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final UserManager userManager;

    public TestConsoleServlet(TemplateRenderer renderer, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, OsgiTestClassLoader testLoader, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, UserManager userManager) {
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.testLoader = testLoader;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            if (!this.isAdmin()) {
                this.redirectToLogin(request, response);
                return;
            }
        }
        catch (WebSudoSessionException wse) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("contextPath", this.applicationProperties.getBaseUrl());
        context.put("productName", this.applicationProperties.getDisplayName().toLowerCase());
        BundleTestClassesManager manager = BundleTestClassesManager.instance();
        String bundle = request.getParameter(BUNDLE_PARAM);
        HashSet<Bundle> osgiBundles = new HashSet<Bundle>(this.testLoader.findAllBundles());
        HashSet<Bundle> testBundles = new HashSet<Bundle>(osgiBundles);
        testBundles.addAll(manager.getAllBundles());
        if (null == bundle) {
            if (testBundles.size() > 1) {
                ArrayList<BundleNameAndPlugin> bundleNamesAndPlugins = new ArrayList<BundleNameAndPlugin>();
                for (Bundle testBundle : testBundles) {
                    Plugin plugin = null;
                    String pluginKey = OsgiHeaderUtil.getPluginKey((Bundle)testBundle);
                    if (StringUtils.isNotBlank((CharSequence)pluginKey)) {
                        plugin = this.pluginAccessor.getPlugin(pluginKey);
                    }
                    if (null == plugin) continue;
                    bundleNamesAndPlugins.add(new BundleNameAndPlugin(testBundle.getSymbolicName(), plugin));
                }
                context.put("bundleNamesAndPlugins", bundleNamesAndPlugins);
                this.renderer.render(BUNDLE_TEMPLATE, context, (Writer)response.getWriter());
                return;
            }
            if (!testBundles.isEmpty()) {
                bundle = ((Bundle)testBundles.iterator().next()).getSymbolicName();
            }
        }
        if (null != bundle && this.hasBundleKey(bundle, testBundles)) {
            Bundle ourBundle = this.getBundleForKey(bundle, testBundles);
            String pluginKey = OsgiHeaderUtil.getPluginKey((Bundle)ourBundle);
            Plugin plugin = null;
            if (StringUtils.isNotBlank((CharSequence)pluginKey)) {
                plugin = this.pluginAccessor.getPlugin(pluginKey);
            }
            if (null != plugin) {
                context.put("testPlugin", plugin);
            }
            if (testBundles.size() > 1) {
                context.put("hasMultipleTestPlugins", true);
            } else {
                context.put("hasMultipleTestPlugins", false);
            }
            context.put("bundleSymbolicName", bundle);
            this.renderer.render(CONSOLE_TEMPLATE, context, (Writer)response.getWriter());
        } else {
            context.put("bundleSymbolicName", bundle);
            this.renderer.render(ERROR_TEMPLATE, context, (Writer)response.getWriter());
        }
    }

    private boolean hasBundleKey(String bundleKey, Set<Bundle> bundles) {
        boolean hasKey = false;
        for (Bundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(bundleKey)) continue;
            hasKey = true;
            break;
        }
        return hasKey;
    }

    private Bundle getBundleForKey(String bundleKey, Set<Bundle> bundles) {
        Bundle foundBundle = null;
        for (Bundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(bundleKey)) continue;
            foundBundle = bundle;
            break;
        }
        return foundBundle;
    }

    protected boolean isAdmin() {
        if (this.userManager.getRemoteUsername() == null) {
            return false;
        }
        return this.userManager.isSystemAdmin(this.userManager.getRemoteUsername()) || this.userManager.isAdmin(this.userManager.getRemoteUsername());
    }

    protected void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = this.getUri(request);
        String uriString = uri.toASCIIString();
        request.getSession().setAttribute(JIRA_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
        request.getSession().setAttribute(CONF_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
        response.sendRedirect(this.loginUriProvider.getLoginUri(uri).toASCIIString());
    }

    protected URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public class BundleNameAndPlugin {
        private final String bundleSymbolicName;
        private final String bundleDivId;
        private final Plugin plugin;

        public BundleNameAndPlugin(String bundleSymbolicName, Plugin plugin) {
            this.bundleSymbolicName = bundleSymbolicName;
            this.bundleDivId = bundleSymbolicName.replaceAll("\\.", "_");
            this.plugin = plugin;
        }

        public String getBundleSymbolicName() {
            return this.bundleSymbolicName;
        }

        public String getBundleDivId() {
            return this.bundleDivId;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }
    }
}

