/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.parsers;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptorFactory;
import com.atlassian.plugin.module.Dom4jDelegatingElement;
import com.atlassian.plugin.module.Element;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Namespace;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlDescriptorParserUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlDescriptorParserUtils.class);

    public static Document removeAllNamespaces(Document doc) {
        doc.accept((Visitor)new NamespaceCleaner());
        return doc;
    }

    @Deprecated
    public static ModuleDescriptor<?> addModule(ModuleDescriptorFactory moduleDescriptorFactory, Plugin plugin, org.dom4j.Element module) {
        ModuleDescriptor<?> moduleDescriptor = XmlDescriptorParserUtils.newModuleDescriptor(plugin, module, moduleDescriptorFactory);
        moduleDescriptor.init(plugin, (Element)new Dom4jDelegatingElement(module));
        return moduleDescriptor;
    }

    public static ModuleDescriptor<?> addModule(ModuleDescriptorFactory moduleDescriptorFactory, Plugin plugin, Element module) {
        return XmlDescriptorParserUtils.addModule(moduleDescriptorFactory, plugin, module.getDelegate());
    }

    @Deprecated
    static ModuleDescriptor<?> newModuleDescriptor(Plugin plugin, org.dom4j.Element element, ModuleDescriptorFactory moduleDescriptorFactory) {
        ModuleDescriptor moduleDescriptor;
        String name = element.getName();
        try {
            moduleDescriptor = moduleDescriptorFactory.getModuleDescriptor(name);
        }
        catch (Throwable e) {
            UnrecognisedModuleDescriptor unrecognisedModuleDescriptor = UnrecognisedModuleDescriptorFactory.createUnrecognisedModuleDescriptor(plugin, element, e, moduleDescriptorFactory);
            log.error("There were problems loading the module '{}' in plugin '{}'. The module has been disabled.", (Object)name, (Object)plugin.getName());
            log.error(unrecognisedModuleDescriptor.getErrorText(), e);
            return unrecognisedModuleDescriptor;
        }
        return moduleDescriptor;
    }

    static ModuleDescriptor<?> newModuleDescriptor(Plugin plugin, Element element, ModuleDescriptorFactory moduleDescriptorFactory) {
        return XmlDescriptorParserUtils.newModuleDescriptor(plugin, element.getDelegate(), moduleDescriptorFactory);
    }

    private static final class NamespaceCleaner
    extends VisitorSupport {
        private NamespaceCleaner() {
        }

        public void visit(Document document) {
            ((DefaultElement)document.getRootElement()).setNamespace(Namespace.NO_NAMESPACE);
            document.getRootElement().additionalNamespaces().clear();
        }

        public void visit(Namespace namespace) {
            namespace.detach();
        }

        public void visit(Attribute node) {
            if (node.toString().contains("xmlns") || node.toString().contains("xsi:")) {
                node.detach();
            }
        }

        public void visit(org.dom4j.Element node) {
            if (node instanceof DefaultElement) {
                ((DefaultElement)node).setNamespace(Namespace.NO_NAMESPACE);
            }
        }
    }
}

