/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.storage;

import com.atlassian.nps.plugin.NpsStatus;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonServerStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(CommonServerStorageService.class);
    private final PluginSettingsFactory pluginSettingsFactory;

    public CommonServerStorageService(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public boolean putSetting(NpsStatus.Key key, String newValue) {
        try {
            this.pluginSettingsFactory.createGlobalSettings().put(key.getKey(), (Object)newValue);
            return true;
        }
        catch (RuntimeException e) {
            LOG.warn("Couldn't change the NPS status. This can safely be ignored during plugin shutdown. Detail: " + e.getMessage());
            return false;
        }
    }

    public String getSetting(NpsStatus.Key key) {
        try {
            return (String)this.pluginSettingsFactory.createGlobalSettings().get(key.getKey());
        }
        catch (RuntimeException e) {
            LOG.warn("Couldn't check the NPS status. This can safely be ignored during plugin shutdown. Detail: " + e.getMessage());
            return null;
        }
    }

    public void deleteSetting(NpsStatus.Key key) {
        try {
            this.pluginSettingsFactory.createGlobalSettings().remove(key.getKey());
        }
        catch (RuntimeException e) {
            LOG.warn("Couldn't delete the NPS status. This can safely be ignored during plugin shutdown. Detail: " + e.getMessage());
        }
    }
}

