/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.jira;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.nps.plugin.NpsStatus;
import com.atlassian.nps.plugin.analytics.AnalyticsEnabledStateService;
import com.atlassian.nps.plugin.analytics.AnalyticsUploadableService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.webresource.condition.SimpleUrlReadingCondition;
import java.util.Map;

public class NpsEnabledUrlReadingCondition
extends SimpleUrlReadingCondition {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FeatureManager featureManager;
    private final AnalyticsEnabledStateService analyticsEnabledStateService;
    private final AnalyticsUploadableService analyticsUploadableService;
    private final NpsStatus npsStatus;
    private static final String QUERY_PARAM_NAME = "jira-nps-enabled";
    private String disableFeatureKey;

    public NpsEnabledUrlReadingCondition(PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, FeatureManager featureManager, AnalyticsEnabledStateService analyticsEnabledStateService, AnalyticsUploadableService analyticsUploadableService, NpsStatus npsStatus) {
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.featureManager = featureManager;
        this.analyticsEnabledStateService = analyticsEnabledStateService;
        this.analyticsUploadableService = analyticsUploadableService;
        this.npsStatus = npsStatus;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.disableFeatureKey = params.get("disableFeatureKey");
    }

    protected boolean isConditionTrue() {
        return !this.isAnonymousAccessEnabled() && this.isUserLoggedIn() && this.isFeatureEnabled() && this.shouldShowNps();
    }

    protected String queryKey() {
        return QUERY_PARAM_NAME;
    }

    private boolean isAnonymousAccessEnabled() {
        return this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, null);
    }

    private boolean isUserLoggedIn() {
        return this.jiraAuthenticationContext.isLoggedInUser();
    }

    private boolean isFeatureEnabled() {
        return this.disableFeatureKey == null || !this.featureManager.isEnabled(this.disableFeatureKey);
    }

    private boolean shouldShowNps() {
        return this.featureManager.isOnDemand() || this.areBtfConditionsMet();
    }

    private boolean areBtfConditionsMet() {
        return this.analyticsEnabledStateService.canCollectAnalytics() && this.analyticsUploadableService.hasUploadedDataRecently() && this.npsStatus.isNpsEnabled();
    }
}

