/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.jira.servicedesk;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.nps.plugin.jira.servicedesk.JiraApplicationUserWrapper;
import com.atlassian.nps.plugin.tracker.MethodConfiguration;
import com.atlassian.nps.plugin.tracker.SingleMethodServiceServiceTracker;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDeskLicenseServiceTracker
extends SingleMethodServiceServiceTracker {
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskLicenseServiceTracker.class);
    private static final String METHOD_NAME = "hasAgentLicense";
    private static final Supplier<List<Class<?>>> PARAMETER_TYPES_SUPPLIER = new Supplier<List<Class<?>>>(){

        public List<Class<?>> get() {
            return ImmutableList.of(JiraApplicationUserWrapper.getApplicationUserClass());
        }
    };
    private final Function<UserKey, Boolean> hasAgentLicenseFunction = new Function<UserKey, Boolean>(){

        public Boolean apply(UserKey input) {
            Method method = ServiceDeskLicenseServiceTracker.this.getMethod();
            if (method == null) {
                return false;
            }
            try {
                ApplicationUser applicationUser = JiraApplicationUserWrapper.getApplicationUserFromKey(input);
                if (applicationUser == null) {
                    return false;
                }
                Either result = (Either)method.invoke(ServiceDeskLicenseServiceTracker.this.getService(), applicationUser);
                return (Boolean)result.right().getOrElse((Object)false);
            }
            catch (Exception e) {
                log.error("Error invoking ServiceDeskLicenseService#hasAgentLicense", (Throwable)e);
                return false;
            }
        }
    };

    ServiceDeskLicenseServiceTracker(BundleContext bundleContext) {
        super(bundleContext, "com.atlassian.servicedesk.api.license.ServiceDeskLicenseService", new MethodConfiguration(METHOD_NAME, PARAMETER_TYPES_SUPPLIER));
    }

    public boolean hasAgentLicense(@Nonnull Option<UserKey> userKey) {
        return (Boolean)userKey.map(this.hasAgentLicenseFunction).getOrElse((Object)false);
    }
}

