/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.util;

import com.atlassian.plugins.navlink.consumer.menu.services.MenuService;
import com.atlassian.plugins.navlink.util.OnDemandUtils;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class EnvironmentFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final String SITE_ADMINS_GROUP = "site-admins";
    private final UserManager userManager;
    private final MenuService menuService;

    public EnvironmentFunction(UserManager userManager, MenuService menuService) {
        this.userManager = userManager;
        this.menuService = menuService;
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("{}");
    }

    public String getName() {
        return "environment";
    }

    public String apply(Object ... args) {
        JSONObject jsonObject = new JSONObject();
        UserKey remoteUserKey = this.userManager.getRemoteUserKey();
        try {
            jsonObject.put("isUserAdmin", this.userManager.isAdmin(remoteUserKey));
            jsonObject.put("isAppSuggestionAvailable", this.isAppSuggestionAvailable(remoteUserKey));
            jsonObject.put("isSiteAdminUser", this.isSiteAdminUser(remoteUserKey));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonObject.toString();
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)0);
    }

    private boolean isAppSuggestionAvailable(UserKey remoteUserKey) {
        return remoteUserKey != null && OnDemandUtils.isOndemand() && !this.menuService.isNoThanksButtonClicked();
    }

    private boolean isSiteAdminUser(UserKey remoteUserKey) {
        return remoteUserKey != null && (this.userManager.isSystemAdmin(remoteUserKey) || this.userManager.isUserInGroup(remoteUserKey, SITE_ADMINS_GROUP));
    }
}

