/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.navigation.plugin;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.navlink.producer.navigation.plugin.NavigationLinkModuleDescriptor;
import com.atlassian.plugins.navlink.producer.navigation.services.NavigationLinkRepository;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLink;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PluginModuleTypeBasedNavigationLinkRepository
implements NavigationLinkRepository {
    private final PluginAccessor pluginAccessor;

    public PluginModuleTypeBasedNavigationLinkRepository(@Nonnull PluginAccessor pluginAccessor) {
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor);
    }

    @Override
    public Iterable<RawNavigationLink> matching(@Nullable Predicate<RawNavigationLink> criteria) {
        List<NavigationLinkModuleDescriptor> enabledModuleDescriptors = this.getEnabledModuleDescriptors();
        Iterable<RawNavigationLink> navigationLinkEntities = this.convertToLinks(enabledModuleDescriptors);
        Iterable<RawNavigationLink> result = this.filterByCriteria(criteria, navigationLinkEntities);
        return Lists.newArrayList(result);
    }

    @Override
    public Iterable<RawNavigationLink> all() {
        return this.matching(null);
    }

    @Nonnull
    private List<NavigationLinkModuleDescriptor> getEnabledModuleDescriptors() {
        List<NavigationLinkModuleDescriptor> result = this.pluginAccessor.getEnabledModuleDescriptorsByClass(NavigationLinkModuleDescriptor.class);
        return result != null ? result : Collections.emptyList();
    }

    @Nonnull
    private Iterable<RawNavigationLink> convertToLinks(@Nonnull List<NavigationLinkModuleDescriptor> enabledModuleDescriptors) {
        return Iterables.transform(enabledModuleDescriptors, (Function)new Function<NavigationLinkModuleDescriptor, RawNavigationLink>(){

            public RawNavigationLink apply(@Nullable NavigationLinkModuleDescriptor input) {
                if (input != null) {
                    Map context = input.getContextProvider() == null ? Collections.emptyMap() : input.getContextProvider().getContextMap(Collections.emptyMap());
                    return input.getCondition() == null || input.getCondition().shouldDisplay(context) ? input.getModule() : null;
                }
                return null;
            }
        });
    }

    @Nonnull
    private Iterable<RawNavigationLink> filterByCriteria(@Nullable Predicate<RawNavigationLink> criteria, @Nonnull Iterable<RawNavigationLink> navigationLinkEntities) {
        return criteria != null ? Iterables.filter(navigationLinkEntities, criteria) : navigationLinkEntities;
    }
}

