/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.failurecache.CacheLoader;
import com.atlassian.failurecache.ExpiringValue;
import com.atlassian.plugins.navlink.consumer.menu.client.capabilities.CapabilitiesClient;
import com.atlassian.plugins.navlink.consumer.menu.services.IgnoreRemotePluginApplicationLinkPredicate;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;

public class CapabilitiesCacheLoader
implements CacheLoader<ApplicationId, RemoteApplicationWithCapabilities> {
    private final ReadOnlyApplicationLinkService readOnlyApplicationLinkService;
    private final ApplicationLinkService applicationLinkService;
    private final CapabilitiesClient capabilitiesClient;

    public CapabilitiesCacheLoader(ReadOnlyApplicationLinkService readOnlyApplicationLinkService, ApplicationLinkService applicationLinkService, CapabilitiesClient capabilitiesClient) {
        this.readOnlyApplicationLinkService = readOnlyApplicationLinkService;
        this.applicationLinkService = applicationLinkService;
        this.capabilitiesClient = capabilitiesClient;
    }

    public ImmutableSet<ApplicationId> getKeys() {
        Iterable allApplicationLinks = this.readOnlyApplicationLinkService.getApplicationLinks();
        Iterable goodApplicationLinks = Iterables.filter((Iterable)allApplicationLinks, (Predicate)Predicates.not((Predicate)new IgnoreRemotePluginApplicationLinkPredicate(this.applicationLinkService)));
        Iterable goodApplicationIds = Iterables.transform((Iterable)goodApplicationLinks, this.toApplicationId());
        return ImmutableSet.copyOf((Iterable)goodApplicationIds);
    }

    public ListenableFuture<ExpiringValue<RemoteApplicationWithCapabilities>> loadValue(ApplicationId applicationId) {
        try {
            ReadOnlyApplicationLink applicationLink = this.getApplicationLink(applicationId);
            return this.capabilitiesClient.getCapabilities(applicationLink);
        }
        catch (RuntimeException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        catch (TypeNotInstalledException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    private ReadOnlyApplicationLink getApplicationLink(ApplicationId applicationId) throws TypeNotInstalledException {
        return (ReadOnlyApplicationLink)Preconditions.checkNotNull((Object)this.readOnlyApplicationLinkService.getApplicationLink(applicationId), (Object)("Application link with application id '" + applicationId + "' is not existing."));
    }

    private Function<ReadOnlyApplicationLink, ApplicationId> toApplicationId() {
        return new Function<ReadOnlyApplicationLink, ApplicationId>(){

            public ApplicationId apply(@Nullable ReadOnlyApplicationLink from) {
                return from != null ? from.getId() : null;
            }
        };
    }
}

