/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.menu.services;

import com.atlassian.failurecache.Cache;
import com.atlassian.failurecache.CacheFactory;
import com.atlassian.failurecache.CacheLoader;
import com.atlassian.failurecache.Cacheable;
import com.atlassian.failurecache.Refreshable;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.plugins.navlink.consumer.menu.services.CapabilitiesCacheLoader;
import com.atlassian.plugins.navlink.consumer.menu.services.RemoteApplications;
import com.atlassian.plugins.navlink.producer.capabilities.CapabilityKey;
import com.atlassian.plugins.navlink.producer.capabilities.RemoteApplicationWithCapabilities;
import com.atlassian.plugins.navlink.util.executor.DaemonExecutorService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class CachingLinkedApplicationCapabilitiesImpl
implements Cacheable,
InitializingBean,
Runnable,
Refreshable,
RemoteApplications,
LinkedApplicationCapabilities {
    private static final long INITIAL_DELAY_IN_SECONDS = Long.getLong("navlink.capabilitiescache.initialdelay", 30L);
    private static final long DELAY_IN_SECONDS = Long.getLong("navlink.capabilitiescache.delay", 10L);
    private static final Logger logger = LoggerFactory.getLogger(CachingLinkedApplicationCapabilitiesImpl.class);
    private final Cache<RemoteApplicationWithCapabilities> cache;
    private final DaemonExecutorService executorService;

    public CachingLinkedApplicationCapabilitiesImpl(DaemonExecutorService executorService, CapabilitiesCacheLoader capabilitiesCacheLoader, CacheFactory cacheFactory) {
        this(executorService, (Cache<RemoteApplicationWithCapabilities>)cacheFactory.createExpirationDateBasedCache((CacheLoader)capabilitiesCacheLoader));
    }

    @VisibleForTesting
    CachingLinkedApplicationCapabilitiesImpl(DaemonExecutorService executorService, Cache<RemoteApplicationWithCapabilities> cache) {
        this.executorService = executorService;
        this.cache = cache;
    }

    @Override
    public Set<RemoteApplicationWithCapabilities> capableOf(CapabilityKey capabilityKey) {
        return this.capableOf(capabilityKey.getKey());
    }

    @Override
    public Set<RemoteApplicationWithCapabilities> capableOf(String capabilityKey) {
        Preconditions.checkNotNull((Object)capabilityKey, (Object)"capabilityKey");
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)this.cache.getValues(), this.filterBy(capabilityKey)));
    }

    @Override
    public void run() {
        this.refreshCache();
    }

    public int getCachePriority() {
        return 500;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ListenableFuture<?> refreshCache() {
        try {
            return this.cache.refresh();
        }
        catch (RuntimeException e) {
            logger.debug("Failed to refresh linked application capabilities cache", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService.scheduleWithFixedDelay(this, INITIAL_DELAY_IN_SECONDS, DELAY_IN_SECONDS, TimeUnit.SECONDS);
    }

    private Predicate<RemoteApplicationWithCapabilities> filterBy(final String capabilityKey) {
        return new Predicate<RemoteApplicationWithCapabilities>(){

            public boolean apply(@Nullable RemoteApplicationWithCapabilities application) {
                return application != null && application.hasCapability(capabilityKey);
            }
        };
    }
}

