(function ($, NL) {
    function trackEvent(action, label, value) {
        try {
            NL.trackEvent("helpmenu", action, label, value);
        } catch (e) {
            AJS.log("failed to track analytics event, category: helpmenu, action: " + action + ", label: " + label + ", value: " + value);
        }
    }

    $(function () {
        var $helpMenu = $('#system-help-menu-content,#help-menu-link-content,#bamboo\\.global\\.header-help\\.menu');

        $helpMenu.bind({
            'aui-dropdown2-show':function (e) {
                trackEvent('show', '');
            },
            'aui-dropdown2-hide':function (e) {
                trackEvent('hide', '');
            }
        }).find('a').unbind('.analytics').bind('click.analytics', function () {
                // the href attribute may be a string or a NamedNodeMap entry
                var attribute = this.attributes['href'];
                trackEvent('linkFollowed', typeof attribute === 'object' ? attribute.value : attribute);
            }
        ).addClass('interactive');
    });

}(jQuery, window.NL = (window.NL || {})));