/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.consumer.http;

import com.atlassian.plugins.navlink.consumer.http.HttpClientFactory;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;

public class HttpClientFactoryImpl
implements HttpClientFactory {
    private static final int SOCKET_TIMEOUT = Integer.getInteger("navlink.httpclient.sotimeout", 3000);
    private static final int CONNECTION_TIMEOUT = Integer.getInteger("navlink.httpclient.conntimeout", 1500);
    private static final int CONNECTION_POOL_TIMEOUT_IN_MILLIS = Integer.getInteger("navlink.httpclient.pool.timeout", 3600000);

    @Override
    public HttpClient createHttpClient() {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient(this.createClientConnectionManager(), this.createParams());
        defaultHttpClient.setRoutePlanner(this.createRoutePlaner());
        defaultHttpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        return defaultHttpClient;
    }

    private ClientConnectionManager createClientConnectionManager() {
        return new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), (long)CONNECTION_POOL_TIMEOUT_IN_MILLIS, TimeUnit.MILLISECONDS);
    }

    private HttpParams createParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        params.setIntParameter("http.socket.timeout", SOCKET_TIMEOUT);
        params.setIntParameter("http.connection.timeout", CONNECTION_TIMEOUT);
        return params;
    }

    private HttpRoutePlanner createRoutePlaner() {
        return new ProxySelectorRoutePlanner(SchemeRegistryFactory.createDefault(), ProxySelector.getDefault());
    }
}

