package com.atlassian.plugins.navlink.util.i18n;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Strings;
import org.apache.commons.lang.StringUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Resolve keys with a specified language (fixes SAL shortcoming).
 */
public class LocaleSupportingI18nResolverWorkAround
{
    private final I18nResolver i18nResolver;

    public LocaleSupportingI18nResolverWorkAround(final I18nResolver i18nResolver)
    {
        this.i18nResolver = i18nResolver;
    }

    @Nonnull
    public String getText(@Nonnull final Locale locale, @Nullable String key)
    {
        checkNotNull(locale);
        return key != null ? Strings.nullToEmpty(translateKey(key, locale)) : "";
    }

    @Nonnull
    public String getText(@Nonnull final Locale locale, @Nullable String key, @Nonnull final Serializable...arguments)
    {
        checkNotNull(locale);
        checkNotNull(arguments);
        final String pattern = getText(locale, key);
        try
        {
            return MessageFormat.format(pattern, arguments);
        }
        catch (RuntimeException e)
        {
            return pattern;
        }
    }

    @Nullable
    private String translateKey(@Nonnull final String key, @Nonnull final Locale locale)
    {
        return StringUtils.defaultIfEmpty(i18nResolver.getAllTranslationsForPrefix(key, locale).get(key), key);
    }
}
