package com.atlassian.plugins.navlink.util.darkfeatures;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;

import java.util.Map;

public class DarkFeatureCondition implements Condition
{
    private final DarkFeatureService darkFeatureService;

    private String featureKey;

    public DarkFeatureCondition(final DarkFeatureService darkFeatureService)
    {
        this.darkFeatureService = darkFeatureService;
    }

    @Override
    public void init(final Map<String, String> params) throws PluginParseException
    {
        this.featureKey = params.get("key");
    }

    @Override
    public boolean shouldDisplay(final Map<String, Object> context)
    {
        return featureKey != null && darkFeatureService.isDarkFeatureEnabledForCurrentUser(featureKey);
    }
}
