package com.atlassian.plugins.navlink.util.darkfeatures;

import com.atlassian.confluence.setup.settings.DarkFeaturesManager;

public class ConfluenceDarkFeatureService implements DarkFeatureService
{
    private final DarkFeaturesManager darkFeaturesManager;

    public ConfluenceDarkFeatureService(final DarkFeaturesManager darkFeaturesManager)
    {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    @Override
    public boolean isDarkFeatureEnabledForCurrentUser(final String featureKey)
    {
        return darkFeaturesManager.getDarkFeatures().isFeatureEnabled(featureKey);
    }
}
