package com.atlassian.plugins.navlink.util.darkfeatures;

public class BambooDarkFeatureService implements DarkFeatureService
{
    private static final String DARKFEATURES_PREFIX = "bamboo.darkfeature.";
    private static final String SAL_DARKFEATURES_PREFIX = "atlassian.darkfeature.";

    @Override
    public boolean isDarkFeatureEnabledForCurrentUser(final String featureKey)
    {
        final Object property = System.getProperties().get(DARKFEATURES_PREFIX + featureKey);
        final Object salProperty = System.getProperties().get(SAL_DARKFEATURES_PREFIX + featureKey);

        return property != null ? Boolean.parseBoolean(property.toString()) : salProperty != null && Boolean.parseBoolean(salProperty.toString());
    }
}
