package com.atlassian.plugins.navlink.producer.navigation.rest;

import javax.annotation.Nonnull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import static com.google.common.base.Preconditions.checkNotNull;

@XmlJavaTypeAdapter(NavigationLinkIdTypeAdapter.class)
public class NavigationLinkId
{
    private final String navigationLinkId;

    public NavigationLinkId(@Nonnull final String navigationLinkId)
    {
        this.navigationLinkId = checkNotNull(navigationLinkId);
    }

    public String get()
    {
        return navigationLinkId;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        else if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final NavigationLinkId that = (NavigationLinkId) o;

        return navigationLinkId.equals(that.navigationLinkId);

    }

    @Override
    public int hashCode()
    {
        return navigationLinkId.hashCode();
    }

    @Override
    public String toString()
    {
        return navigationLinkId;
    }
}
