package com.atlassian.plugins.navlink.producer.navigation;

import com.atlassian.plugins.custom_apps.api.CustomApp;
import com.atlassian.plugins.navlink.producer.navigation.links.LinkSource;
import com.atlassian.plugins.navlink.producer.navigation.links.SourceType;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLink;
import org.apache.commons.lang.StringUtils;

/**
 * Builders to convert to navlinks from various other representations.
 *
 * @since 3.0
 */
public final class NavigationLinks
{

    private NavigationLinks()
    {
        throw new AssertionError("Don't instantiate me");
    }

    public static NavigationLinkBuilder copyOf(CustomApp customApp)
    {
        return new NavigationLinkBuilder()
                .source(retrieveSource(customApp))
                .href(customApp.getUrl())
                .label(customApp.getDisplayName())
                .applicationType(customApp.getSourceApplicationType())
                .self(customApp.isSelf());
    }

    public static NavigationLinkBuilder copyOf(RawNavigationLink navigationLink)
    {
        final NavigationLinkBuilder builder = new NavigationLinkBuilder().copy(navigationLink);
        if (navigationLink.getSource().type() == SourceType.UNKNOWN)
        {
            builder.source(LinkSource.localDefault());
        }
        return builder;
    }

    private static LinkSource retrieveSource(CustomApp customApp)
    {
        return isLocalCustomApp(customApp) ? LinkSource.localDefault() : LinkSource.remoteDefault();
    }

    /**
     * Check if a CustomApp entry is locally generated. Currently check by seeing if the Custom App has a non blank base
     * url, as the base url is used to signify the source application of the custom app.
     *
     * @return true if the app is local.
     */
    private static boolean isLocalCustomApp(CustomApp ca)
    {
        return StringUtils.isBlank(ca.getSourceApplicationUrl());
    }
}
