package com.atlassian.plugins.navlink.producer.navigation;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;

import javax.annotation.concurrent.Immutable;
import java.util.Locale;
import java.util.Set;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * All navigation links of a particular application in a specific language.
 * @since 3.2
 */
@Immutable
public final class ApplicationNavigationLinks
{
    private final Locale locale;
    private final ImmutableSet<NavigationLink> navigationLinks;

    public ApplicationNavigationLinks(final Locale locale, final Set<NavigationLink> navigationLinks)
    {
        this.locale = checkNotNull(locale, "locale");
        this.navigationLinks = ImmutableSet.copyOf(checkNotNull(navigationLinks, "navigationLinks"));
    }

    /**
     * @return the locale in which the navigation links were requested;
     */
    public Locale getLocale()
    {
        return locale;
    }

    /**
     * @return the application's navigation links
     */
    public ImmutableSet<NavigationLink> getNavigationLinks()
    {
        return navigationLinks;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (o == null || getClass() != o.getClass())
        {
            return false;
        }

        final ApplicationNavigationLinks that = (ApplicationNavigationLinks) o;
        return locale.equals(that.locale) && navigationLinks.equals(that.navigationLinks);

    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(locale, navigationLinks);
    }

    @Override
    public String toString()
    {
        return "ApplicationNavigationLinks{locale=" + locale + ", navigationLinks=" + navigationLinks + '}';
    }
}
