package com.atlassian.plugins.navlink.producer.contentlinks.services;


import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.fugue.Pair;
import com.atlassian.plugins.navlink.consumer.projectshortcuts.rest.UnauthenticatedRemoteApplication;
import com.atlassian.plugins.navlink.producer.contentlinks.plugin.ContentLinkModuleDescriptor;
import com.atlassian.plugins.navlink.producer.contentlinks.rest.ContentLinkEntity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Map;

/**
 * Service to collect information required for the Project Links.
 */
public interface ContentLinksService
{
    /**
     * Retrieves all content link descriptors for the local application
     * @param context
     * @param entityType
     * @return
     */
    @Nonnull
    List<ContentLinkModuleDescriptor> getAllLocalContentLinks(@Nonnull Map<String, Object> context, @Nullable TypeId entityType);

    /**
     * Retrieves content links from all linked entities.
     * @param key of the current entity
     * @param entityTypeId of the current entity
     * @return project shortcuts from all linked entities.
     */
    @Nonnull
    List<ContentLinkEntity> getAllRemoteContentLinks(@Nonnull String key, @Nonnull TypeId entityTypeId);


    /**
     * Retrieves content links from all linked entities, preserving information on Applications which require authentication
     *
     * @param key of the current entity
     * @param entityTypeId of the current entity
     * @return project shortcuts from all linked entities, along with all unauthenticated remote applications.
     */
    @Nonnull
    Pair<Iterable<ContentLinkEntity>, Iterable<UnauthenticatedRemoteApplication>> getAllRemoteContentLinksAndUnauthedApps(@Nonnull String key, @Nonnull TypeId entityTypeId);
}
