package com.atlassian.plugins.navlink.producer.contentlinks.rest;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON;

import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.CustomContentLinkService;
import com.atlassian.plugins.navlink.producer.contentlinks.plugin.ContentLinkModuleDescriptor;
import com.atlassian.plugins.navlink.producer.contentlinks.services.ContentLinksService;
import com.atlassian.plugins.navlink.util.url.UrlFactory;
import com.google.common.collect.Maps;

import org.apache.commons.lang.StringUtils;

import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Path("/")
public class ContentLinkResource
{
    private ContentLinksService contentLinksService;
    private CustomContentLinkService customContentLinksService;

    private UrlFactory urlFactory;

    public ContentLinkResource(ContentLinksService contentLinksService,
            CustomContentLinkService customContentLinksService, UrlFactory urlFactory)
    {
        this.contentLinksService = contentLinksService;
        this.customContentLinksService = customContentLinksService;
        this.urlFactory = urlFactory;
    }

    /**
     * Returns the project information and local links for the project. Will not return any information if user can not
     * see the project.
     * 
     * @deprecated
     */
    @GET
    @Path("local/{key}")
    @Produces(APPLICATION_JSON)
    public Response getLocalContentLinksAndProjectDetails(@PathParam("key") String key,
            @Nullable @QueryParam("entityType") String entityType, @Context HttpServletRequest request)
    {
        if (StringUtils.isBlank(key))
        {
            return Response.status(Response.Status.BAD_REQUEST).entity("Please provide a project key").build();
        }

        List<ContentLinkEntity> contentLinkEntities = fetchContentLinks(key, request);

        return Response.ok(contentLinkEntities).build();
    }

    private List<ContentLinkEntity> fetchContentLinks(String key, HttpServletRequest request)
    {
        Map<String, Object> context = Maps.newHashMap();
        context.put("key", key);
        // todo do we want all web params added?

        List<ContentLinkModuleDescriptor> localContentLinksDescriptors = contentLinksService.getAllLocalContentLinks(context, null);
        ContentLinkEntityFactory factory = new ContentLinkEntityFactory(request, context, urlFactory);

        List<ContentLinkEntity> contentLinkEntities = new ArrayList(factory.create(localContentLinksDescriptors));
        contentLinkEntities.addAll(factory.createFromCustomContentLinks(customContentLinksService
                .getCustomContentLinks(key), true));

        contentLinkEntities.addAll(factory.createFromCustomContentLinks(customContentLinksService.getPluginCustomContentLinks(key), true));

        return contentLinkEntities;
    }

    @GET
    @Path("/{key}")
    @Produces(APPLICATION_JSON)
    public Response getContentLinks(@PathParam("key") String key, @Context HttpServletRequest request)
    {
        if (StringUtils.isBlank(key))
        {
            return Response.status(Response.Status.BAD_REQUEST).entity("Please provide a project key").build();
        }

        List<ContentLinkEntity> contentLinkEntities = fetchContentLinks(key, request);

        return Response.ok(new ContentLinksEnvelope(contentLinkEntities)).build();
    }
}
