package com.atlassian.plugins.navlink.producer.capabilities;

import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.google.common.base.Objects;
import org.joda.time.DateTime;

import javax.annotation.concurrent.Immutable;
import java.util.Map;

@Immutable
public class RemoteApplicationWithCapabilities extends ApplicationWithCapabilities implements LinkedAppWithCapabilities
{
    private final String applicationLinkId;
    private final String selfUrl;

    public RemoteApplicationWithCapabilities(final String applicationLinkId, final String selfUrl, final String type,
                                             final DateTime buildDate, final Map<String, String> capabilities)
    {
        super(type, buildDate, capabilities);
        this.applicationLinkId = applicationLinkId;
        this.selfUrl = selfUrl;
    }

    @Override
    public String getApplicationLinkId()
    {
        return applicationLinkId;
    }

    /**
     * The origin url of the remote application's capabilities. If you are interested in requesting the capabilities
     * again, use this url.
     *
     * @return origin url of the remote application's capabilities
     */
    public String getSelfUrl()
    {
        return selfUrl;
    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(applicationLinkId, selfUrl, id, name, type, buildDate);
    }

    @Override
    public boolean equals(final Object obj)
    {
        if (obj == this) 
        {
            return true;
        }
        else if (!(obj instanceof RemoteApplicationWithCapabilities))
        {
            return false;
        }
        else
        {
            final RemoteApplicationWithCapabilities that = (RemoteApplicationWithCapabilities) obj;
            return Objects.equal(applicationLinkId, that.applicationLinkId) &&
                    Objects.equal(selfUrl, that.selfUrl) &&
                    Objects.equal(id, that.id) &&
                    Objects.equal(name, that.name) &&
                    Objects.equal(buildDate, that.buildDate) &&
                    Objects.equal(type, that.type);
        }
    }

    @Override
    public String toString()
    {
        return "RemoteApplicationWithCapabilities{" +
                "applicationLinkId='" + applicationLinkId + '\'' +
                ", selfUrl='" + selfUrl + '\'' +
                ", id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", type='" + type + '\'' +
                ", buildDate='" + buildDate + '\'' +
                ", capabilities=" + capabilities +
                '}';
    }
}
