package com.atlassian.plugins.navlink.producer;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;

/**
 * Forward incoming requests to the configured target.
 */
public class ForwardServletFilter implements Filter
{
    static final String TARGET_INIT_PARAMETER = "target";

    private final Logger logger = LoggerFactory.getLogger(ForwardServletFilter.class);
    private String target;

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException
    {
        target = Strings.nullToEmpty(filterConfig.getInitParameter(TARGET_INIT_PARAMETER));
        if (target.isEmpty())
        {
            logger.warn("No target url was configured for servlet filter with name '{}'; ignoring incoming requests.", filterConfig.getFilterName());
        }
    }

    @Override
    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException
    {
        if (!target.isEmpty())
        {
            redirectToTarget(request, response);
        }
        else
        {
            chain.doFilter(request, response);
        }
    }

    private void redirectToTarget(final ServletRequest request, final ServletResponse response) throws ServletException, IOException
    {
        if (logger.isDebugEnabled())
        {
            logger.debug("redirecting request to {}", target);
        }
        request.getRequestDispatcher(target).forward(request, response);
    }

    @Override
    public void destroy()
    {
    }
}
